/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.leveling;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.leveling.LevelingManager;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuddyAchievement {
    private final AchievementType type;
    private final String description;
    private final int experienceReward;
    private final Consumer<LevelingManager> customRewardAction;
    private boolean unlocked;
    private long unlockTimestamp;

    public BuddyAchievement(@NotNull AchievementType type, @NotNull String description, int experienceReward, @Nullable Consumer<LevelingManager> customRewardAction) {
        this.type = type;
        this.description = description;
        this.experienceReward = Math.max(0, experienceReward);
        this.customRewardAction = customRewardAction;
        this.unlocked = false;
        this.unlockTimestamp = 0L;
    }

    public AchievementType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public int getExperienceReward() {
        return this.experienceReward;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public long getUnlockTimestamp() {
        return this.unlockTimestamp;
    }

    public boolean unlock(@NotNull LevelingManager levelingManager) {
        if (this.unlocked) {
            return false;
        }
        this.unlocked = true;
        this.unlockTimestamp = System.currentTimeMillis();
        if (this.experienceReward > 0) {
            levelingManager.addExperience(this.experienceReward);
        }
        if (this.customRewardAction != null) {
            this.customRewardAction.accept(levelingManager);
        }
        return true;
    }

    public void reset() {
        this.unlocked = false;
        this.unlockTimestamp = 0L;
    }

    public static enum AchievementType {
        FIRST_STEPS("First Steps", "First interaction with your buddy", 1),
        FRIENDLY_TOUCH("Friendly Touch", "Pet your buddy 10 times", 1),
        CARETAKER("Caretaker", "Feed your buddy 5 times", 1),
        PLAYFUL_FRIEND("Playful Friend", "Play with your buddy for the first time", 1),
        CLEANUP_CREW("Cleanup Crew", "Clean up 5 poops", 1),
        BEST_BUDDIES("Best Buddies", "Reach maximum happiness with your buddy", 2),
        WELL_FED("Well Fed", "Keep your buddy perfectly fed for a full session", 2),
        ENERGIZER("Energizer", "Keep your buddy's energy above 80% for an entire session", 2),
        FUN_TIMES("Fun Times", "Reach maximum fun level with your buddy", 2),
        MARATHON_SESSION("Marathon Session", "Use the layout editor with your buddy for over an hour", 2),
        MASTER_TRAINER("Master Trainer", "Reach level 10 with your buddy", 3),
        COMPLETION_COLLECTOR("Completion Collector", "Unlock all basic achievements", 3),
        MIDNIGHT_COMPANION("Midnight Companion", "Work with your buddy after midnight", 4),
        DESIGN_MARATHON("Design Marathon", "Create 10 layouts with your buddy present", 4),
        LOYAL_FRIEND("Loyal Friend", "Interact with your buddy every day for a week", 4),
        PERFECT_HARMONY("Perfect Harmony", "Keep all buddy stats above 90% for an entire session", 5),
        ACHIEVEMENT_HUNTER("Achievement Hunter", "Unlock all other achievements", 5);

        private final String name;
        private final String defaultDescription;
        private final int tier;

        private AchievementType(String name, String defaultDescription, int tier) {
            this.name = name;
            this.defaultDescription = defaultDescription;
            this.tier = tier;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultDescription() {
            return this.defaultDescription;
        }

        public int getTier() {
            return this.tier;
        }
    }
}

