/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.ui;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRequirementScreen
extends Screen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer parent;
    protected final LoadingRequirementInstance instance;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementInstance> callback;
    protected ScrollArea requirementsListScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ScrollArea descriptionScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ExtendedEditBox searchBar;
    private static final Comparator<LoadingRequirement> REQUIREMENT_DISPLAY_NAME_COMPARATOR = Comparator.comparing(requirement -> requirement.getDisplayName(), String.CASE_INSENSITIVE_ORDER).thenComparing(LoadingRequirement::getDisplayName).thenComparing(LoadingRequirement::getIdentifier);

    public BuildRequirementScreen(@Nullable Screen parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementInstance instanceToEdit, @NotNull Consumer<LoadingRequirementInstance> callback) {
        super((Component)(instanceToEdit != null ? Component.m_237115_((String)"fancymenu.requirements.screens.edit_requirement") : Component.m_237115_((String)"fancymenu.requirements.screens.add_requirement")));
        this.parentScreen = parentScreen;
        this.parent = parent;
        this.instance = instanceToEdit != null ? instanceToEdit : new LoadingRequirementInstance(null, null, LoadingRequirementInstance.RequirementMode.IF, parent);
        this.isEdit = instanceToEdit != null;
        this.callback = callback;
    }

    protected void m_7856_() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        this.searchBar = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 21, 66, this.f_96543_ / 2 - 40 - 2, 18, (Component)Component.m_237119_());
        this.searchBar.setHintFancyMenu(consumes -> Component.m_237115_((String)"fancymenu.requirements.build_requirement.screen.search_requirement"));
        this.searchBar.m_94144_(oldSearchValue);
        this.searchBar.m_94151_(s -> this.updateRequirementsList());
        this.m_142416_((GuiEventListener)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.m_264313_((GuiEventListener)this.searchBar);
        this.requirementsListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.requirementsListScrollArea.setHeight(this.f_96544_ - 85 - 25, true);
        this.requirementsListScrollArea.setX(20.0f, true);
        this.requirementsListScrollArea.setY(90.0f, true);
        this.m_142416_(this.requirementsListScrollArea);
        this.descriptionScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.descriptionScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
        this.descriptionScrollArea.setX((float)(this.f_96543_ - 20) - this.descriptionScrollArea.getWidthWithBorder(), true);
        this.descriptionScrollArea.setY(65.0f, true);
        this.descriptionScrollArea.horizontalScrollBar.active = false;
        this.m_142416_(this.descriptionScrollArea);
        int doneButtonX = this.f_96543_ - 20 - 150;
        int doneButtonY = this.f_96544_ - 20 - 20;
        int cancelButtonX = doneButtonX;
        int cancelButtonY = doneButtonY - 5 - 20;
        int editValueButtonX = doneButtonX;
        int editValueButtonY = (this.isEdit ? doneButtonY : cancelButtonY) - 15 - 20;
        int requirementModeButtonX = doneButtonX;
        int requirementModeButtonY = editValueButtonY - 5 - 20;
        ExtendedButton editValueButton = new ExtendedButton(editValueButtonX, editValueButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.requirements.screens.build_screen.edit_value"), button -> {
            if (this.instance.requirement != null) {
                this.instance.requirement.editValue(this, this.instance);
            }
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement != null && !this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.edit_value.desc.no_value", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.edit_value.desc.normal", new String[0]));
        }).setIsActiveSupplier(consumes -> this.instance.requirement != null && this.instance.requirement.hasValue());
        this.m_142416_((GuiEventListener)editValueButton);
        UIBase.applyDefaultWidgetSkinTo(editValueButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.done"), button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            this.callback.accept(this.instance);
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.finish.desc.no_requirement_selected", new String[0]));
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.finish.desc.no_value_set", new String[0]));
            }
            return null;
        }).setIsActiveSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return false;
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return false;
            }
            return true;
        });
        this.m_142416_((GuiEventListener)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.cancel"), button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.instance);
            } else {
                this.callback.accept(null);
            }
        }).setIsActiveSupplier(consumes -> !this.isEdit);
        cancelButton.f_93624_ = !this.isEdit;
        this.m_142416_((GuiEventListener)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        ExtendedButton requirementModeButton = new ExtendedButton(requirementModeButtonX, requirementModeButtonY, 150, 20, (Component)Component.m_237119_(), button -> {
            this.instance.mode = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? LoadingRequirementInstance.RequirementMode.IF_NOT : LoadingRequirementInstance.RequirementMode.IF;
        }).setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.requirement_mode.desc", new String[0]))).setLabelSupplier(consumes -> {
            if (this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                return Component.m_237115_((String)"fancymenu.requirements.screens.build_screen.requirement_mode.normal");
            }
            return Component.m_237115_((String)"fancymenu.requirements.screens.build_screen.requirement_mode.opposite");
        });
        this.m_142416_((GuiEventListener)requirementModeButton);
        UIBase.applyDefaultWidgetSkinTo(requirementModeButton);
        this.updateRequirementsList();
        this.setDescription(this.instance.requirement);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.instance);
        } else {
            this.callback.accept(null);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.requirements.screens.build_screen.available_requirements"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        MutableComponent descLabel = Component.m_237115_((String)"fancymenu.requirements.screens.build_screen.requirement_description");
        int descLabelWidth = this.f_96547_.m_92852_((FormattedText)descLabel);
        graphics.m_280614_(this.f_96547_, (Component)descLabel, this.f_96543_ - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
    }

    protected void setDescription(@Nullable LoadingRequirement requirement) {
        this.descriptionScrollArea.clearEntries();
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
        if (requirement != null && requirement.getDescription() != null) {
            for (String s : requirement.getDescription()) {
                this.addDescriptionLine((Component)Component.m_237113_((String)s));
            }
        }
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
    }

    protected void addDescriptionLine(@NotNull Component line) {
        ArrayList<Component> lines = new ArrayList<Component>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15.0f);
        if (this.f_96547_.m_92852_((FormattedText)line) > maxWidth) {
            this.f_96547_.m_92865_().m_92414_((FormattedText)line, maxWidth, Style.f_131099_).forEach(formatted -> lines.add((Component)TextFormattingUtils.convertFormattedTextToComponent(formatted)));
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, (Component)component, entry -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected boolean requirementFitsSearchValue(@NotNull LoadingRequirement requirement, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (requirement.getDisplayName().toLowerCase().contains(s)) {
            return true;
        }
        return this.requirementDescriptionContains(requirement, s);
    }

    protected boolean requirementDescriptionContains(@NotNull LoadingRequirement requirement, @NotNull String s) {
        List desc = Objects.requireNonNullElse(requirement.getDescription(), new ArrayList());
        for (String line : desc) {
            if (!line.toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfRequirementsList(@Nullable String category) {
        block7: {
            LinkedHashMap<String, List<LoadingRequirement>> categories;
            block6: {
                String searchValue;
                String string = searchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
                if (searchValue.isBlank()) {
                    searchValue = null;
                }
                this.requirementsListScrollArea.clearEntries();
                if (searchValue != null) {
                    List<LoadingRequirement> requirements = LoadingRequirementRegistry.getRequirements();
                    requirements.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR);
                    for (LoadingRequirement r : requirements) {
                        if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance()) || !this.requirementFitsSearchValue(r, searchValue)) continue;
                        MutableComponent mutableComponent = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                        RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)mutableComponent, UIBase.getUIColorTheme().listing_dot_color_1, entry -> {
                            this.instance.requirement = r;
                            this.setDescription(this.instance.requirement);
                        });
                        e.requirement = r;
                        this.requirementsListScrollArea.addEntry(e);
                    }
                    return;
                }
                categories = LoadingRequirementRegistry.getRequirementsOrderedByCategories();
                categories.values().forEach(list -> list.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR));
                ArrayList<Map.Entry<String, List<LoadingRequirement>>> sortedCategories = new ArrayList<Map.Entry<String, List<LoadingRequirement>>>(categories.entrySet());
                sortedCategories.sort(Comparator.comparing(entry -> (String)entry.getKey(), String.CASE_INSENSITIVE_ORDER).thenComparing(Map.Entry::getKey));
                if (category != null) break block6;
                for (Map.Entry entry2 : sortedCategories) {
                    MutableComponent label = Component.m_237113_((String)((String)entry2.getKey())).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                    TextListScrollAreaEntry e = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_2, entry -> {
                        this.setContentOfRequirementsList((String)entry2.getKey());
                        this.instance.requirement = null;
                        this.setDescription(null);
                    });
                    e.setSelectable(false);
                    this.requirementsListScrollArea.addEntry(e);
                }
                List<LoadingRequirement> uncategorized = LoadingRequirementRegistry.getRequirementsWithoutCategory();
                uncategorized.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR);
                for (LoadingRequirement r : uncategorized) {
                    if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                    MutableComponent label = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                    RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1, entry -> {
                        this.instance.requirement = r;
                        this.setDescription(this.instance.requirement);
                    });
                    e.requirement = r;
                    this.requirementsListScrollArea.addEntry(e);
                }
                break block7;
            }
            MutableComponent backLabel = Component.m_237115_((String)"fancymenu.requirements.screens.lists.back").m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            TextListScrollAreaEntry textListScrollAreaEntry = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)backLabel, UIBase.getUIColorTheme().listing_dot_color_2, entry -> {
                this.setContentOfRequirementsList(null);
                this.instance.requirement = null;
                this.setDescription(null);
            });
            textListScrollAreaEntry.setSelectable(false);
            this.requirementsListScrollArea.addEntry(textListScrollAreaEntry);
            List<LoadingRequirement> l = categories.get(category);
            if (l == null) break block7;
            for (LoadingRequirement r : l) {
                if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                MutableComponent label = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1, entry -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }
        }
    }

    protected void updateRequirementsList() {
        this.setContentOfRequirementsList(null);
        if (this.instance.requirement != null) {
            this.setContentOfRequirementsList(this.instance.requirement.getCategory());
            for (ScrollAreaEntry e : this.requirementsListScrollArea.getEntries()) {
                if (!(e instanceof RequirementScrollEntry) || ((RequirementScrollEntry)e).requirement != this.instance.requirement) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public class RequirementScrollEntry
    extends TextListScrollAreaEntry {
        public LoadingRequirement requirement;
        protected long lastClickTime;
        protected static final long DOUBLE_CLICK_TIME = 500L;

        public RequirementScrollEntry(@NotNull ScrollArea parent, @NotNull Component text, @NotNull DrawableColor listDotColor, Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, text, listDotColor, onClick);
            this.lastClickTime = 0L;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 500L && this.requirement != null && BuildRequirementScreen.this.instance.requirement == this.requirement) {
                if (this.requirement.hasValue()) {
                    BuildRequirementScreen.this.instance.requirement.editValue(BuildRequirementScreen.this, BuildRequirementScreen.this.instance);
                } else {
                    Minecraft.m_91087_().m_91152_(BuildRequirementScreen.this.parentScreen);
                    BuildRequirementScreen.this.callback.accept(BuildRequirementScreen.this.instance);
                }
                this.lastClickTime = 0L;
                return;
            }
            this.lastClickTime = currentTime;
            super.onClick(entry, mouseX, mouseY, button);
        }
    }
}

