/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtBlockListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtEntityListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStopLookingAtBlockListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStopLookingAtEntityListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Unique
    private static final double ENTITY_LOOK_DISTANCE_FANCYMENU = 20.0;
    @Unique
    private static final double BLOCK_LOOK_DISTANCE_FANCYMENU = 20.0;
    @Shadow
    @Final
    Minecraft f_109059_;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void before_render_FancyMenu(float partialTicks, long nanoTime, boolean renderLevel, CallbackInfo info) {
        ScreenCustomization.onPreGameRenderTick();
    }

    @Inject(method={"pick(F)V"}, at={@At(value="TAIL")})
    private void tail_onPick_FancyMenu(float partialTicks, CallbackInfo info) {
        BlockHitResult blockHitResult;
        if (this.f_109059_ == null) {
            return;
        }
        HitResult hitResult = this.f_109059_.f_91077_;
        OnStartLookingAtBlockListener startBlockListener = Listeners.ON_START_LOOKING_AT_BLOCK;
        OnStopLookingAtBlockListener stopBlockListener = Listeners.ON_STOP_LOOKING_AT_BLOCK;
        OnStartLookingAtEntityListener startLookingListener = Listeners.ON_START_LOOKING_AT_ENTITY;
        OnStopLookingAtEntityListener stopLookingListener = Listeners.ON_STOP_LOOKING_AT_ENTITY;
        if (hitResult == null) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            MixinGameRenderer.stopLooking_FancyMenu(startLookingListener, stopLookingListener);
            return;
        }
        Entity cameraEntity = this.f_109059_.m_91288_();
        if (cameraEntity == null) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            MixinGameRenderer.stopLooking_FancyMenu(startLookingListener, stopLookingListener);
            return;
        }
        Vec3 eyePosition = cameraEntity.m_20299_(partialTicks);
        EntityHitResult extendedEntityHit = MixinGameRenderer.findExtendedEntityHit_FancyMenu(cameraEntity, partialTicks);
        if (extendedEntityHit == null && hitResult instanceof EntityHitResult) {
            EntityHitResult vanillaEntityHit;
            extendedEntityHit = vanillaEntityHit = (EntityHitResult)hitResult;
        }
        if (extendedEntityHit != null) {
            Entity targetEntity = extendedEntityHit.m_82443_();
            double distance = extendedEntityHit.m_82450_().m_82554_(eyePosition);
            startLookingListener.onLookAtEntity(targetEntity, distance);
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        MixinGameRenderer.stopLooking_FancyMenu(startLookingListener, stopLookingListener);
        ClientLevel clientLevel = this.f_109059_.f_91073_;
        if (clientLevel == null) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        HitResult blockPickResult = cameraEntity.m_19907_(20.0, partialTicks, false);
        if (!(blockPickResult instanceof BlockHitResult) || (blockHitResult = (BlockHitResult)blockPickResult).m_6662_() != HitResult.Type.BLOCK) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockState blockState = clientLevel.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        double distance = blockHitResult.m_82450_().m_82554_(eyePosition);
        if (distance > 20.0) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        OnStartLookingAtBlockListener.LookedBlockData previousBlock = startBlockListener.getCurrentBlockData();
        if (previousBlock != null) {
            boolean sameBlock;
            boolean bl = sameBlock = previousBlock.blockPos().equals((Object)blockPos) && previousBlock.blockState().equals(blockState) && previousBlock.levelKey().equals((Object)clientLevel.m_46472_());
            if (!sameBlock) {
                stopBlockListener.onStopLooking(previousBlock);
            }
        }
        startBlockListener.onLookAtBlock(clientLevel, blockHitResult, distance);
    }

    @Unique
    private static void stopLooking_FancyMenu(OnStartLookingAtEntityListener startListener, OnStopLookingAtEntityListener stopListener) {
        OnStartLookingAtEntityListener.LookedEntityData previousEntity = startListener.getCurrentEntityData();
        if (previousEntity != null) {
            stopListener.onStopLooking(previousEntity);
            startListener.clearCurrentEntity();
        }
    }

    @Unique
    private static void stopLookingBlock_FancyMenu(OnStartLookingAtBlockListener startListener, OnStopLookingAtBlockListener stopListener) {
        OnStartLookingAtBlockListener.LookedBlockData previousBlock = startListener.getCurrentBlockData();
        if (previousBlock != null) {
            stopListener.onStopLooking(previousBlock);
        }
        startListener.clearCurrentBlock();
    }

    @Unique
    @Nullable
    private static EntityHitResult findExtendedEntityHit_FancyMenu(Entity cameraEntity, float partialTicks) {
        double blockDistanceSqr;
        double maxDistanceSqr;
        AABB searchBox;
        Vec3 viewVector;
        Vec3 reachVector;
        Vec3 eyePosition = cameraEntity.m_20299_(partialTicks);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)cameraEntity, (Vec3)eyePosition, (Vec3)(reachVector = eyePosition.m_82549_((viewVector = cameraEntity.m_20252_(partialTicks)).m_82490_(20.0))), (AABB)(searchBox = cameraEntity.m_20191_().m_82369_(viewVector.m_82490_(20.0)).m_82400_(1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)(maxDistanceSqr = 400.0));
        if (entityHitResult == null) {
            return null;
        }
        Vec3 hitLocation = entityHitResult.m_82450_();
        double entityDistanceSqr = hitLocation.m_82557_(eyePosition);
        if (entityDistanceSqr > maxDistanceSqr) {
            return null;
        }
        HitResult blockHitResult = cameraEntity.m_19907_(20.0, partialTicks, false);
        if (blockHitResult != null && blockHitResult.m_6662_() != HitResult.Type.MISS && (blockDistanceSqr = blockHitResult.m_82450_().m_82557_(eyePosition)) <= entityDistanceSqr) {
            return null;
        }
        return entityHitResult;
    }
}

