/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MixinMultiPlayerGameMode {
    @Unique
    @Nullable
    private String capturedItemUseKey_FancyMenu;
    @Unique
    @Nullable
    private String capturedUseItemKey_FancyMenu;

    @WrapOperation(method={"destroyBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;destroy(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void wrap_destroy_in_destroyBlock_FancyMenu(Block block, LevelAccessor level, BlockPos pos, BlockState state, Operation<Void> operation) {
        String usedItemKey = this.getMainHandItemKey_FancyMenu();
        operation.call(new Object[]{block, level, pos, state});
        if (level != null && level.m_5776_()) {
            Listeners.ON_BLOCK_BROKE.onBlockBroke(pos, state, usedItemKey);
        }
    }

    @Inject(method={"performUseItemOn"}, at={@At(value="HEAD")})
    private void before_performUseItemOn_captureItem_FancyMenu(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        this.capturedItemUseKey_FancyMenu = this.resolveItemKeyFromHand_FancyMenu((Player)player, hand);
    }

    @Inject(method={"performUseItemOn"}, at={@At(value="RETURN")})
    private void after_performUseItemOn_FancyMenu(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result = (InteractionResult)cir.getReturnValue();
        if (result != null && result.m_19077_()) {
            String itemKey;
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            BlockPos blockPos = hitResult.m_82425_().m_7949_();
            BlockState state = null;
            String blockKey = "";
            String targetPosX = "-1";
            String targetPosY = "-1";
            String targetPosZ = "-1";
            if (level != null && level.m_46749_(blockPos)) {
                state = level.m_8055_(blockPos);
                blockKey = this.resolveBlockKey_FancyMenu(state);
                targetPosX = Integer.toString(blockPos.m_123341_());
                targetPosY = Integer.toString(blockPos.m_123342_());
                targetPosZ = Integer.toString(blockPos.m_123343_());
                Listeners.ON_INTERACTED_WITH_BLOCK.onBlockInteracted(blockPos, state);
            }
            if ((itemKey = this.capturedItemUseKey_FancyMenu) == null) {
                itemKey = this.resolveItemKeyFromHand_FancyMenu((Player)player, hand);
            }
            Listeners.ON_ITEM_USED.onItemUsed(itemKey, "block", "", blockKey, targetPosX, targetPosY, targetPosZ);
        }
        this.capturedItemUseKey_FancyMenu = null;
    }

    @WrapOperation(method={"performUseItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult wrap_useOn_FancyMenu(ItemStack stack, UseOnContext context, Operation<InteractionResult> operation) {
        BlockState placedState;
        Level level;
        BlockItem blockItem = stack.m_41720_() instanceof BlockItem ? (BlockItem)stack.m_41720_() : null;
        BlockPos placePos = null;
        if (blockItem != null) {
            placePos = new BlockPlaceContext(context).m_8083_();
        }
        InteractionResult result = (InteractionResult)operation.call(new Object[]{stack, context});
        if (blockItem != null && result != null && result.m_19077_() && (level = context.m_43725_()) != null && level.m_5776_() && placePos != null && (placedState = level.m_8055_(placePos)).m_60713_(blockItem.m_40614_())) {
            Listeners.ON_BLOCK_PLACED.onBlockPlaced(placePos, placedState);
        }
        return result;
    }

    @Inject(method={"useItem"}, at={@At(value="HEAD")})
    private void before_useItem_captureItem_FancyMenu(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        this.capturedUseItemKey_FancyMenu = player instanceof LocalPlayer ? this.resolveItemKeyFromHand_FancyMenu(player, hand) : null;
    }

    @Inject(method={"useItem"}, at={@At(value="RETURN")})
    private void after_useItem_FancyMenu(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result = (InteractionResult)cir.getReturnValue();
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            if (result != null && result.m_19077_()) {
                String itemKey = this.capturedUseItemKey_FancyMenu;
                if (itemKey == null) {
                    itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
                }
                String usedOnType = "none";
                String entityKey = "";
                String targetPosX = "-1";
                String targetPosY = "-1";
                String targetPosZ = "-1";
                if (localPlayer.m_6117_()) {
                    usedOnType = "self";
                    entityKey = this.resolveEntityKey_FancyMenu((Entity)localPlayer);
                    targetPosX = Double.toString(localPlayer.m_20185_());
                    targetPosY = Double.toString(localPlayer.m_20186_());
                    targetPosZ = Double.toString(localPlayer.m_20189_());
                }
                Listeners.ON_ITEM_USED.onItemUsed(itemKey, usedOnType, entityKey, "", targetPosX, targetPosY, targetPosZ);
            }
        }
        this.capturedUseItemKey_FancyMenu = null;
    }

    @WrapOperation(method={"interact"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult wrap_interactWithEntity_FancyMenu(Player player, Entity target, InteractionHand hand, Operation<InteractionResult> original) {
        String itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        InteractionResult result = (InteractionResult)original.call(new Object[]{player, target, hand});
        if (itemKey == null) {
            itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        }
        this.handleEntityInteractionResult_FancyMenu(player, target, result, itemKey);
        return result;
    }

    @WrapOperation(method={"interactAt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;interactAt(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult wrap_interactAtWithEntity_FancyMenu(Entity target, Player player, Vec3 hitVec, InteractionHand hand, Operation<InteractionResult> original) {
        String itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        InteractionResult result = (InteractionResult)original.call(new Object[]{target, player, hitVec, hand});
        if (itemKey == null) {
            itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        }
        this.handleEntityInteractionResult_FancyMenu(player, target, result, itemKey);
        return result;
    }

    @Unique
    private void handleEntityInteractionResult_FancyMenu(Player player, Entity target, InteractionResult result, @Nullable String itemKey) {
        if (!(player instanceof LocalPlayer) || target == null) {
            return;
        }
        if (result == null || !result.m_19077_()) {
            return;
        }
        String entityKey = this.resolveEntityKey_FancyMenu(target);
        Listeners.ON_ITEM_USED.onItemUsed(itemKey, "entity", entityKey, "", Double.toString(target.m_20185_()), Double.toString(target.m_20186_()), Double.toString(target.m_20189_()));
        Listeners.ON_INTERACTED_WITH_ENTITY.onEntityInteracted(target);
    }

    @Unique
    private String getMainHandItemKey_FancyMenu() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer == null) {
            return null;
        }
        return this.resolveItemKey_FancyMenu(localPlayer.m_21205_());
    }

    @Unique
    @Nullable
    private String resolveItemKeyFromHand_FancyMenu(@Nullable Player player, @Nullable InteractionHand hand) {
        if (player == null || hand == null) {
            return null;
        }
        return this.resolveItemKey_FancyMenu(player.m_21120_(hand));
    }

    @Unique
    @Nullable
    private String resolveItemKey_FancyMenu(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return null;
        }
        ResourceLocation itemLocation = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return itemLocation != null ? itemLocation.toString() : null;
    }

    @Unique
    private String resolveBlockKey_FancyMenu(@Nullable BlockState state) {
        if (state == null) {
            return "";
        }
        ResourceLocation blockLocation = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        return blockLocation != null ? blockLocation.toString() : "";
    }

    @Unique
    private String resolveEntityKey_FancyMenu(@Nullable Entity entity) {
        if (entity == null) {
            return "";
        }
        ResourceLocation entityLocation = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        return entityLocation != null ? entityLocation.toString() : "";
    }
}

