/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.server;

import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.entities.EntityEventPacket;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class MixinLivingEntity {
    @Inject(method={"die"}, at={@At(value="TAIL")})
    private void after_die_FancyMenu(@NotNull DamageSource damageSource, CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        Level level = self.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.m_7654_() == null) {
            return;
        }
        this.broadcastEntityDeath_FancyMenu(serverLevel, self, damageSource);
    }

    @Unique
    private void broadcastEntityDeath_FancyMenu(@NotNull ServerLevel level, @NotNull LivingEntity entity, @NotNull DamageSource damageSource) {
        EntityEventPacket packet = new EntityEventPacket();
        packet.event_type = EntityEventPacket.EntityEventType.DEATH;
        ResourceLocation entityKeyLocation = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        packet.entity_key = entityKeyLocation != null ? entityKeyLocation.toString() : null;
        packet.entity_uuid = entity.m_20148_().toString();
        packet.pos_x = entity.m_20185_();
        packet.pos_y = entity.m_20186_();
        packet.pos_z = entity.m_20189_();
        ResourceLocation levelLocation = level.m_46472_().m_135782_();
        packet.level_identifier = levelLocation != null ? levelLocation.toString() : null;
        packet.damage_type = this.resolveDamageTypeKey_FancyMenu(damageSource);
        Entity killer = this.resolveKillerEntity_FancyMenu(entity, damageSource);
        if (killer != null) {
            packet.killer_name = killer.m_5446_().getString();
            packet.killer_uuid = killer.m_20148_().toString();
            ResourceLocation killerKeyLocation = BuiltInRegistries.f_256780_.m_7981_((Object)killer.m_6095_());
            String string = packet.killer_key = killerKeyLocation != null ? killerKeyLocation.toString() : null;
            if (packet.killer_key == null && killer instanceof Player) {
                packet.killer_key = "minecraft:player";
            }
        } else {
            packet.killer_name = null;
            packet.killer_uuid = null;
            packet.killer_key = null;
        }
        PacketHandler.sendToAllFancyMenuClients(level.m_7654_(), packet);
    }

    @Unique
    @Nullable
    private Entity resolveKillerEntity_FancyMenu(@NotNull LivingEntity victim, @Nullable DamageSource damageSource) {
        LivingEntity killCredit;
        if (damageSource != null) {
            Entity killer = damageSource.m_7639_();
            if (killer != null) {
                return killer;
            }
            Entity directEntity = damageSource.m_7640_();
            if (directEntity != null) {
                return directEntity;
            }
        }
        return (killCredit = victim.m_21232_()) != null ? killCredit : null;
    }

    @Unique
    @NotNull
    private String resolveDamageTypeKey_FancyMenu(@Nullable DamageSource damageSource) {
        if (damageSource == null) {
            return "unknown";
        }
        return damageSource.m_269150_().m_203543_().map(key -> key.m_135782_().toString()).orElse("unknown");
    }
}

