/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMinecraft;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    public static final ResourceLocation FULLY_TRANSPARENT_TEXTURE = new ResourceLocation("fancymenu", "textures/fully_transparent.png");
    private static final List<DeferredScreenRenderingTask> DEFERRED_SCREEN_RENDERING_TASKS = new ArrayList<DeferredScreenRenderingTask>();
    private static boolean lockDepthTest = false;
    private static boolean tooltipRenderingBlocked = false;

    public static void renderMissing(@NotNull GuiGraphics graphics, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        graphics.m_280509_(x, y, x + partW, y + partH, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        graphics.m_280509_(x + partW, y, x + width, y + partH, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.m_280509_(x, y + partH, x + partW, y + height, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.m_280509_(x + partW, y + partH, x + width, y + height, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void setDepthTestLocked(boolean locked) {
        lockDepthTest = locked;
    }

    public static boolean isDepthTestLocked() {
        return lockDepthTest;
    }

    public static void setTooltipRenderingBlocked(boolean blocked) {
        tooltipRenderingBlocked = blocked;
    }

    public static boolean isTooltipRenderingBlocked() {
        return tooltipRenderingBlocked;
    }

    public static void addDeferredScreenRenderingTask(@NotNull DeferredScreenRenderingTask task) {
        DEFERRED_SCREEN_RENDERING_TASKS.add(task);
    }

    @NotNull
    public static List<DeferredScreenRenderingTask> getDeferredScreenRenderingTasks() {
        return new ArrayList<DeferredScreenRenderingTask>(DEFERRED_SCREEN_RENDERING_TASKS);
    }

    public static void executeAndClearDeferredScreenRenderingTasks(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        List<DeferredScreenRenderingTask> tasks = RenderingUtils.getDeferredScreenRenderingTasks();
        DEFERRED_SCREEN_RENDERING_TASKS.clear();
        tasks.forEach(task -> task.render(graphics, mouseX, mouseY, partial));
    }

    public static void blitMirrored(@NotNull GuiGraphics graphics, ResourceLocation atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, -1);
    }

    public static void blitMirrored(@NotNull GuiGraphics graphics, ResourceLocation atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight, int colorTint) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, colorTint);
    }

    public static void blitMirroredScaled(@NotNull GuiGraphics graphics, ResourceLocation atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int renderWidth, int renderHeight, int textureWidth, int textureHeight, int color) {
        float minU = (float)u / (float)textureWidth;
        float maxU = (float)(u + spriteWidth) / (float)textureWidth;
        float minV = (float)v / (float)textureHeight;
        float maxV = (float)(v + spriteHeight) / (float)textureHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder consumer = Tesselator.m_85913_().m_85915_();
        consumer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        consumer.m_252986_(matrix4f, (float)x, (float)y, 0.0f).m_7421_(maxU, minV).m_193479_(color);
        consumer.m_252986_(matrix4f, (float)x, (float)(y + renderHeight), 0.0f).m_7421_(maxU, maxV).m_193479_(color);
        consumer.m_252986_(matrix4f, (float)(x + renderWidth), (float)(y + renderHeight), 0.0f).m_7421_(minU, maxV).m_193479_(color);
        consumer.m_252986_(matrix4f, (float)(x + renderWidth), (float)y, 0.0f).m_7421_(minU, minV).m_193479_(color);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)consumer.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void blitRepeat(@NotNull GuiGraphics graphics, @NotNull ResourceLocation location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight) {
        graphics.m_280163_(location, x, y, 0.0f, 0.0f, areaRenderWidth, areaRenderHeight, texWidth, texHeight);
    }

    public static void blitNineSlicedTexture(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft) {
        int pieceHeight;
        int j;
        int pieceWidth;
        int i;
        float scale;
        if (borderLeft + borderRight >= textureWidth) {
            scale = (float)(textureWidth - 2) / (float)(borderLeft + borderRight);
            borderLeft = (int)((float)borderLeft * scale);
            borderRight = (int)((float)borderRight * scale);
        }
        if (borderTop + borderBottom >= textureHeight) {
            scale = (float)(textureHeight - 2) / (float)(borderTop + borderBottom);
            borderTop = (int)((float)borderTop * scale);
            borderBottom = (int)((float)borderBottom * scale);
        }
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, borderLeft, borderTop, textureWidth, textureHeight);
        graphics.m_280163_(texture, x + width - borderRight, y, (float)(textureWidth - borderRight), 0.0f, borderRight, borderTop, textureWidth, textureHeight);
        graphics.m_280163_(texture, x, y + height - borderBottom, 0.0f, (float)(textureHeight - borderBottom), borderLeft, borderBottom, textureWidth, textureHeight);
        graphics.m_280163_(texture, x + width - borderRight, y + height - borderBottom, (float)(textureWidth - borderRight), (float)(textureHeight - borderBottom), borderRight, borderBottom, textureWidth, textureHeight);
        int centerWidth = textureWidth - borderLeft - borderRight;
        int centerHeight = textureHeight - borderTop - borderBottom;
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.m_280163_(texture, x + i, y, (float)borderLeft, 0.0f, pieceWidth, borderTop, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.m_280163_(texture, x + i, y + height - borderBottom, (float)borderLeft, (float)(textureHeight - borderBottom), pieceWidth, borderBottom, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.m_280163_(texture, x, y + j, 0.0f, (float)borderTop, borderLeft, pieceHeight, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.m_280163_(texture, x + width - borderRight, y + j, (float)(textureWidth - borderRight), (float)borderTop, borderRight, pieceHeight, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            for (int j2 = borderTop; j2 < height - borderBottom; j2 += centerHeight) {
                int pieceHeight2 = Math.min(centerHeight, height - borderBottom - j2);
                graphics.m_280163_(texture, x + i, y + j2, (float)borderLeft, (float)borderTop, pieceWidth, pieceHeight2, textureWidth, textureHeight);
            }
        }
    }

    public static float getPartialTick() {
        return Minecraft.m_91087_().m_91104_() ? ((IMixinMinecraft)Minecraft.m_91087_()).getPausePartialTickFancyMenu() : Minecraft.m_91087_().m_91296_();
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        Window m = Minecraft.m_91087_().m_91268_();
        m.m_85378_((double)m.m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), ((Boolean)Minecraft.m_91087_().f_91066_.m_231819_().m_231551_()).booleanValue()));
    }

    public static void resetShaderColor(GuiGraphics graphics) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setShaderColor(GuiGraphics graphics, DrawableColor color) {
        Color c = color.getColor();
        float a = Math.min(1.0f, Math.max(0.0f, (float)c.getAlpha() / 255.0f));
        RenderingUtils.setShaderColor(graphics, color, a);
    }

    public static void setShaderColor(GuiGraphics graphics, DrawableColor color, float alpha) {
        Color c = color.getColor();
        float r = Math.min(1.0f, Math.max(0.0f, (float)c.getRed() / 255.0f));
        float g = Math.min(1.0f, Math.max(0.0f, (float)c.getGreen() / 255.0f));
        float b = Math.min(1.0f, Math.max(0.0f, (float)c.getBlue() / 255.0f));
        graphics.m_280246_(r, g, b, alpha);
    }

    public static void setShaderColor(GuiGraphics graphics, int color, float alpha) {
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        graphics.m_280246_(red, green, blue, alpha);
    }

    public static void setShaderColor(GuiGraphics graphics, int color) {
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        graphics.m_280246_(red, green, blue, alpha);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(graphics, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull GuiGraphics graphics, float minX, float minY, float maxX, float maxY, float z, int color) {
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        if (minX < maxX) {
            float $$8 = minX;
            minX = maxX;
            maxX = $$8;
        }
        if (minY < maxY) {
            float $$9 = minY;
            minY = maxY;
            maxY = $$9;
        }
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, minX, minY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, minX, maxY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, maxY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, minY, z).m_85950_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void blitF(@NotNull GuiGraphics graphics, ResourceLocation location, float x, float y, float f3, float f4, float width, float height, float width2, float height2, int color) {
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        graphics.m_280246_(red, green, blue, alpha);
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void blitF(@NotNull GuiGraphics graphics, ResourceLocation location, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(GuiGraphics $$0, ResourceLocation location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, location, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(GuiGraphics graphics, ResourceLocation location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit(graphics, location, $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(GuiGraphics graphics, ResourceLocation location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f $$10 = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder $$11 = Tesselator.m_85913_().m_85915_();
        $$11.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        $$11.m_252986_($$10, $$1, $$3, $$5).m_7421_($$6, $$8).m_5752_();
        $$11.m_252986_($$10, $$1, $$4, $$5).m_7421_($$6, $$9).m_5752_();
        $$11.m_252986_($$10, $$2, $$4, $$5).m_7421_($$7, $$9).m_5752_();
        $$11.m_252986_($$10, $$2, $$3, $$5).m_7421_($$7, $$8).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)$$11.m_231175_());
    }

    public static void enableScissor(@NotNull GuiGraphics graphics, int minX, int minY, int maxX, int maxY) {
        ScreenRectangle r = new ScreenRectangle(minX, minY, maxX - minX, maxY - minY);
        r = RenderingUtils.transformAxisAligned(r, graphics.m_280168_().m_85850_().m_252922_());
        graphics.m_280588_(r.m_274563_(), r.m_274449_(), r.m_274445_(), r.m_274349_());
    }

    public static void disableScissor(@NotNull GuiGraphics graphics) {
        graphics.m_280618_();
    }

    @NotNull
    public static ScreenRectangle transformAxisAligned(@NotNull ScreenRectangle toTransform, @NotNull Matrix4f pose) {
        if (RenderingUtils.isMatrixIdentity(pose)) {
            return toTransform;
        }
        Vector3f vector3f = pose.transformPosition((float)toTransform.m_274563_(), (float)toTransform.m_274449_(), 0.0f, new Vector3f());
        Vector3f vector3f2 = pose.transformPosition((float)toTransform.m_274445_(), (float)toTransform.m_274349_(), 0.0f, new Vector3f());
        return new ScreenRectangle(Mth.m_14143_((float)vector3f.x), Mth.m_14143_((float)vector3f.y), Mth.m_14143_((float)(vector3f2.x - vector3f.x)), Mth.m_14143_((float)(vector3f2.y - vector3f.y)));
    }

    public static boolean isMatrixIdentity(Matrix4f matrix) {
        return (matrix.properties() & 4) != 0;
    }

    @FunctionalInterface
    public static interface DeferredScreenRenderingTask {
        public void render(@NotNull GuiGraphics var1, int var2, int var3, float var4);
    }
}

