/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.TextWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DualTextInputScreen
extends Screen {
    @NotNull
    protected Consumer<Pair<String, String>> callback;
    protected ExtendedEditBox input_one;
    protected ExtendedEditBox input_two;
    protected ExtendedButton cancelButton;
    protected ExtendedButton doneButton;
    protected ConsumingSupplier<DualTextInputScreen, Boolean> textValidator = null;
    protected Tooltip textValidatorFeedbackTooltip = null;
    @NotNull
    protected MutableComponent firstInputLabel;
    @NotNull
    protected MutableComponent secondInputLabel;
    @Nullable
    protected CharacterFilter filter;
    @Nullable
    protected String initialValueOne = null;
    @Nullable
    protected String initialValueTwo = null;
    protected boolean allowPlaceholders = true;

    @NotNull
    public static DualTextInputScreen build(@NotNull Component title, @NotNull Component firstInputLabel, @NotNull Component secondInputLabel, @Nullable CharacterFilter filter, @NotNull Consumer<Pair<String, String>> callback) {
        return new DualTextInputScreen(title, firstInputLabel, secondInputLabel, filter, callback);
    }

    public DualTextInputScreen(@NotNull Component title, @NotNull Component firstInputLabel, @NotNull Component secondInputLabel, @Nullable CharacterFilter filter, @NotNull Consumer<Pair<String, String>> callback) {
        super(title);
        MutableComponent l;
        this.callback = callback;
        this.firstInputLabel = firstInputLabel instanceof MutableComponent ? (l = (MutableComponent)firstInputLabel) : Component.m_237119_();
        this.secondInputLabel = secondInputLabel instanceof MutableComponent ? (l = (MutableComponent)secondInputLabel) : Component.m_237119_();
        this.filter = filter;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int editorButtonWidth = 100;
        int inputWidth = this.allowPlaceholders ? 150 : 250;
        int inputWidthHalf = inputWidth / 2;
        int inputX = centerX - inputWidthHalf - (this.allowPlaceholders ? editorButtonWidth / 2 : 0);
        ((TextWidget)this.m_142416_((GuiEventListener)new TextWidget(0, centerY - 43, this.f_96543_, 20, this.f_96547_, (Component)this.firstInputLabel).centerWidget(this).setTextAlignment(TextWidget.TextAlignment.CENTER).setBaseColor(UIBase.getUIColorTheme().generic_text_base_color))).setShadowEnabled(false);
        String oldValueOne = "";
        if (this.input_one != null) {
            oldValueOne = this.input_one.m_94155_();
        } else if (this.initialValueOne != null) {
            oldValueOne = this.initialValueOne;
        }
        this.input_one = new ExtendedEditBox(this.f_96547_, inputX, centerY - 30, inputWidth, 20, (Component)Component.m_237119_());
        this.input_one.m_94199_(10000000);
        this.input_one.setCharacterFilter(this.filter);
        this.input_one.m_94144_(oldValueOne);
        UIBase.applyDefaultWidgetSkinTo(this.input_one);
        this.m_142416_((GuiEventListener)this.input_one);
        this.m_7522_((GuiEventListener)this.input_one);
        if (this.allowPlaceholders) {
            UIBase.applyDefaultWidgetSkinTo((ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.input_one.m_252754_() + this.input_one.m_5711_() + 5, this.input_one.m_252907_(), editorButtonWidth, 20, (Component)Component.m_237115_((String)"fancymenu.ui.screens.string_builder_screen.edit_in_editor"), button -> {
                TextEditorScreen s = new TextEditorScreen(this.filter != null ? this.filter.convertToLegacyFilter() : null, callback -> {
                    if (callback != null) {
                        this.setFirstText((String)callback);
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                });
                s.setText(this.getFirstText());
                Minecraft.m_91087_().m_91152_((Screen)s);
            })));
        }
        ((TextWidget)this.m_142416_((GuiEventListener)new TextWidget(0, centerY + 27, this.f_96543_, 20, this.f_96547_, (Component)this.secondInputLabel).centerWidget(this).setTextAlignment(TextWidget.TextAlignment.CENTER).setBaseColor(UIBase.getUIColorTheme().generic_text_base_color))).setShadowEnabled(false);
        String oldValueTwo = "";
        if (this.input_two != null) {
            oldValueTwo = this.input_two.m_94155_();
        } else if (this.initialValueTwo != null) {
            oldValueTwo = this.initialValueTwo;
        }
        this.input_two = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, inputX, centerY + 40, inputWidth, 20, (Component)Component.m_237119_());
        this.input_two.m_94199_(10000000);
        this.input_two.setCharacterFilter(this.filter);
        this.input_two.m_94144_(oldValueTwo);
        UIBase.applyDefaultWidgetSkinTo(this.input_two);
        this.m_142416_((GuiEventListener)this.input_two);
        if (this.allowPlaceholders) {
            UIBase.applyDefaultWidgetSkinTo((ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.input_two.m_252754_() + this.input_two.m_5711_() + 5, this.input_two.m_252907_(), editorButtonWidth, 20, (Component)Component.m_237115_((String)"fancymenu.ui.screens.string_builder_screen.edit_in_editor"), button -> {
                TextEditorScreen s = new TextEditorScreen(this.filter != null ? this.filter.convertToLegacyFilter() : null, callback -> {
                    if (callback != null) {
                        this.setSecondText((String)callback);
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                });
                s.setText(this.getSecondText());
                Minecraft.m_91087_().m_91152_((Screen)s);
            })));
        }
        this.cancelButton = new ExtendedButton(this.f_96543_ / 2 - 5 - 100, centerY + 90, 100, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.cancel"), button -> this.m_7379_());
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.doneButton = new ExtendedButton(this.f_96543_ / 2 + 5, centerY + 90, 100, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.done"), button -> {
            if (this.isTextValid()) {
                this.onDone();
            }
        }).setIsActiveSupplier(consumes -> this.isTextValid()).setTooltipSupplier(consumes -> {
            if (this.textValidatorFeedbackTooltip != null) {
                this.textValidatorFeedbackTooltip.setDefaultStyle();
            }
            return this.textValidatorFeedbackTooltip;
        });
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.m_142416_((GuiEventListener)this.doneButton);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent t = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        int titleWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)t);
        graphics.m_280614_(this.f_96547_, (Component)t, this.f_96543_ / 2 - titleWidth / 2, 30, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
    }

    public boolean m_7933_(int button, int p_96553_, int p_96554_) {
        if (button == 257 && this.isTextValid()) {
            this.onDone();
            return true;
        }
        return super.m_7933_(button, p_96553_, p_96554_);
    }

    protected void onDone() {
        this.callback.accept(Pair.of(this.getFirstText(), this.getSecondText()));
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    public DualTextInputScreen setFirstText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        if (this.input_one != null) {
            this.input_one.m_94144_(text);
        } else {
            this.initialValueOne = text;
        }
        return this;
    }

    public DualTextInputScreen setSecondText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        if (this.input_two != null) {
            this.input_two.m_94144_(text);
        } else {
            this.initialValueTwo = text;
        }
        return this;
    }

    @NotNull
    public String getFirstText() {
        if (this.input_one != null) {
            return this.input_one.m_94155_();
        }
        if (this.initialValueOne != null) {
            return this.initialValueOne;
        }
        return "";
    }

    @NotNull
    public String getSecondText() {
        if (this.input_two != null) {
            return this.input_two.m_94155_();
        }
        if (this.initialValueTwo != null) {
            return this.initialValueTwo;
        }
        return "";
    }

    protected boolean isTextValid() {
        if (this.textValidator != null) {
            return this.textValidator.get(this);
        }
        return true;
    }

    public DualTextInputScreen setTextValidator(@Nullable ConsumingSupplier<DualTextInputScreen, Boolean> textValidator) {
        this.textValidator = textValidator;
        return this;
    }

    public DualTextInputScreen setTextValidatorUserFeedback(@Nullable Tooltip feedback) {
        this.textValidatorFeedbackTooltip = feedback;
        return this;
    }

    public boolean isAllowPlaceholders() {
        return this.allowPlaceholders;
    }

    public DualTextInputScreen setAllowPlaceholders(boolean allowPlaceholders) {
        this.allowPlaceholders = allowPlaceholders;
        return this;
    }
}

