/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry;

import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class TextScrollAreaEntry
extends ScrollAreaEntry {
    protected Component text;
    protected int textWidth;
    public Font font;
    protected Consumer<TextScrollAreaEntry> onClickCallback;
    protected int textBaseColor;

    public TextScrollAreaEntry(ScrollArea parent, @NotNull Component text, @NotNull Consumer<TextScrollAreaEntry> onClick) {
        super(parent, 0.0f, 14.0f);
        this.font = Minecraft.m_91087_().f_91062_;
        this.textBaseColor = UIBase.getUIColorTheme().generic_text_base_color.getColorInt();
        this.onClickCallback = onClick;
        this.setText(text);
    }

    @Override
    public void renderEntry(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        float centerY = this.getY() + this.getHeight() / 2.0f;
        int n = (int)(this.getX() + 5.0f);
        Objects.requireNonNull(this.font);
        graphics.m_280614_(this.font, this.text, n, (int)(centerY - 9.0f / 2.0f), this.textBaseColor, false);
    }

    @Override
    public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        this.onClickCallback.accept((TextScrollAreaEntry)entry);
    }

    public void setText(@NotNull Component text) {
        this.text = text;
        this.textWidth = this.font.m_92852_((FormattedText)this.text);
        this.setWidth(5 + this.textWidth + 5);
    }

    public Component getText() {
        return this.text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public int getTextBaseColor() {
        return this.textBaseColor;
    }

    public void setTextBaseColor(int textBaseColor) {
        this.textBaseColor = textBaseColor;
    }
}

