/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.noglow.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lol.sylvie.noglow.NoGlow;
import lol.sylvie.noglow.config.ConfigInstance;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHelper {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_NAME = "noglow.json";

    public static void save(ConfigInstance config) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)config);
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path file = Path.of(configDir.toString(), CONFIG_NAME);
        try (FileWriter writer = new FileWriter(file.toFile());){
            writer.write(json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ConfigInstance load() {
        Gson gson = new Gson();
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path file = Path.of(configDir.toString(), CONFIG_NAME);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return (ConfigInstance)gson.fromJson(Files.readString(file), ConfigInstance.class);
            }
            catch (IOException iOException) {
            }
            catch (JsonSyntaxException | IllegalStateException exception) {
                NoGlow.LOGGER.error("Could not read NoGlow configuration file, continuing without it.", exception);
            }
        }
        return new ConfigInstance(false);
    }
}

