/*
 * Decompiled with CFR 0.152.
 */
package com.example.stringduper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TripwireDupePlugin
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private final Set<String> enabledChunks = new HashSet<String>();
    private final Set<UUID> approvedAdmins = new HashSet<UUID>();
    private final Map<String, ChunkStats> chunkStatsMap = new HashMap<String, ChunkStats>();
    private boolean globalEnabled = true;
    private long dupeDelayTicks = 3L;
    private int requiredProximityChunks = 4;
    private boolean autoLoadChunks = false;
    private final Set<String> operators = new HashSet<String>();
    private boolean autoLoadEnabled = false;
    public boolean itemLimitEnabled = true;
    public int maxItemsPerChunk = 500;
    private boolean globalForceEnable = false;

    public void onEnable() {
        this.loadChunkData();
        if (this.autoLoadChunks) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                for (String string : this.enabledChunks) {
                }
                this.getLogger().info("Autoload enabled: previously enabled chunks restored.");
            }, 20L);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PluginCommand command = this.getCommand("stringdupe");
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
        }
        this.getLogger().info("TripwireDupe plugin enabled.");
        if (this.autoLoadChunks) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                for (String string : new HashSet<String>(this.enabledChunks)) {
                }
                this.getLogger().info("Autoload enabled: previously enabled chunks restored.");
            }, 20L);
        }
    }

    public void onDisable() {
        this.saveChunkData();
        this.getLogger().info("TripwireDupe plugin disabled.");
    }

    private String getChunkKey(Block block) {
        return block.getWorld().getName() + "," + block.getChunk().getX() + "," + block.getChunk().getZ();
    }

    private boolean isAdmin(Player player) {
        return player.isOp() || this.approvedAdmins.contains(player.getUniqueId());
    }

    @EventHandler
    public void onTripwirePhysics(BlockPhysicsEvent event) {
        Levelled waterData;
        final Block block = event.getBlock();
        if (block.getType() != Material.TRIPWIRE) {
            return;
        }
        String chunkKey = this.getChunkKey(block);
        if (!this.globalForceEnable && !this.enabledChunks.contains(chunkKey)) {
            return;
        }
        Tripwire tripwire = (Tripwire)block.getBlockData();
        if (!tripwire.isAttached()) {
            return;
        }
        Block below = block.getRelative(0, -1, 0);
        if (below.getType() != Material.WATER) {
            return;
        }
        BlockData blockData = below.getBlockData();
        if (blockData instanceof Levelled && (waterData = (Levelled)blockData).getLevel() == 0) {
            return;
        }
        boolean playerNearby = block.getWorld().getPlayers().stream().anyMatch(p -> {
            if (!p.getWorld().equals((Object)block.getWorld())) {
                return false;
            }
            Chunk pc = p.getLocation().getChunk();
            Chunk bc = block.getChunk();
            int dx = Math.abs(pc.getX() - bc.getX());
            int dz = Math.abs(pc.getZ() - bc.getZ());
            return dx <= this.requiredProximityChunks && dz <= this.requiredProximityChunks;
        });
        if (!playerNearby) {
            return;
        }
        block.setType(Material.AIR);
        int surroundingItemCount = this.countStringItemsInSurroundingChunks(block.getChunk());
        int totalItemLimit = this.maxItemsPerChunk * 9;
        boolean dropString = surroundingItemCount < totalItemLimit;
        block.setType(Material.AIR);
        if (dropString) {
            block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.STRING));
        }
        this.chunkStatsMap.computeIfAbsent(chunkKey, k -> new ChunkStats()).recordDuplication();
        if (surroundingItemCount < totalItemLimit) {
            block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.STRING));
        }
        this.chunkStatsMap.computeIfAbsent(chunkKey, k -> new ChunkStats()).recordDuplication();
        new BukkitRunnable(){

            public void run() {
                block.setType(Material.TRIPWIRE);
            }
        }.runTaskLater((Plugin)this, this.dupeDelayTicks);
    }

    private void reloadPlugin() {
        this.saveChunkData();
        this.saveOperatorData();
        this.saveConfig();
        this.enabledChunks.clear();
        this.operators.clear();
        this.reloadConfig();
        this.saveDefaultConfig();
        this.loadChunkData();
        this.loadOperatorData();
        this.maxItemsPerChunk = this.getConfig().getInt("dropCap", 100);
        this.dupeDelayTicks = this.getConfig().getInt("dupeDelayTicks", 2);
        this.requiredProximityChunks = this.getConfig().getInt("requiredProximityChunks", 4);
        this.autoLoadEnabled = this.getConfig().getBoolean("autoLoad", false);
    }

    private void saveOperatorData() {
        File file = new File(this.getDataFolder(), "operators.txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String name : this.operators) {
                writer.write(name);
                writer.newLine();
            }
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to save operators: " + e.getMessage());
        }
    }

    private void loadOperatorData() {
        File file = new File(this.getDataFolder(), "operators.txt");
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.operators.add(line.trim());
            }
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to load operators: " + e.getMessage());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe <enable|disable|status|chunkList|global|speed|stats|operator|operators>");
            return true;
        }
        String sub = args[0].toLowerCase();
        String chunkKey = this.getChunkKey(player.getLocation().getBlock());
        block21 : switch (sub) {
            case "reload": {
                if (!this.isAdmin(player)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                this.reloadPlugin();
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aPlugin reloaded successfully.");
                break;
            }
            case "autoload": {
                if (!this.isAdmin(player)) {
                    sender.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe autoload <enable|disable>");
                    return true;
                }
                switch (args[1].toLowerCase()) {
                    case "enable": {
                        this.autoLoadChunks = true;
                        this.saveChunkData();
                        sender.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aAutoload enabled.");
                        break block21;
                    }
                    case "disable": {
                        this.autoLoadChunks = false;
                        this.saveChunkData();
                        sender.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cAutoload disabled.");
                        break block21;
                    }
                }
                sender.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe autoload <enable|disable>");
                break;
            }
            case "dropcap": {
                String arg;
                if (!this.isAdmin(player)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe dropcap <enable|disable|number>");
                    return true;
                }
                switch (arg = args[1].toLowerCase()) {
                    case "enable": {
                        this.itemLimitEnabled = true;
                        player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aDrop cap limiting is now enabled.");
                        break block21;
                    }
                    case "disable": {
                        this.itemLimitEnabled = false;
                        this.maxItemsPerChunk = Integer.MAX_VALUE;
                        player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cDrop cap limiting is now disabled.");
                        break block21;
                    }
                }
                try {
                    int newLimit = Integer.parseInt(arg);
                    if (newLimit < 0) {
                        player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cItem limit must be non-negative.");
                        break;
                    }
                    this.maxItemsPerChunk = newLimit;
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aItem drop cap set to " + this.maxItemsPerChunk + " items across 3x3 chunks.");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cInvalid number or command. Use /stringdupe dropcap <enable|disable|number>");
                }
                break;
            }
            case "proximity": {
                if (!this.isAdmin(player)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe proximity <chunkRadius>");
                    return true;
                }
                try {
                    this.requiredProximityChunks = Math.max(0, Integer.parseInt(args[1]));
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aDupe proximity range set to " + this.requiredProximityChunks + " chunk(s).");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cInvalid number.");
                }
                break;
            }
            case "enable": {
                Block block = player.getLocation().getBlock();
                if (this.globalForceEnable || this.enabledChunks.contains(chunkKey)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eThis chunk is already enabled.");
                    break;
                }
                this.enabledChunks.add(chunkKey);
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aENABLED string duper(s) in this chunk.");
                this.updateTripwires(block);
                break;
            }
            case "disable": {
                if (!this.enabledChunks.contains(chunkKey) && !this.globalForceEnable) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eThis chunk is already disabled.");
                    break;
                }
                this.enabledChunks.remove(chunkKey);
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cDISABLED string duper(s) in this chunk.");
                break;
            }
            case "status": {
                if (this.globalForceEnable || this.enabledChunks.contains(chunkKey)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aENABLED in this chunk.");
                    break;
                }
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cDISABLED in this chunk.");
                break;
            }
            case "stats": {
                ChunkStats stats = this.chunkStatsMap.getOrDefault(chunkKey, new ChunkStats());
                player.sendMessage("\u00a7b\u00a7l[StringDupe Stats]\u00a7r");
                player.sendMessage(" - Duplications: " + stats.totalDupes);
                player.sendMessage(" - Active Time: " + stats.getFormattedTime());
                break;
            }
            case "global": {
                if (!this.isAdmin(player)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe global <enable|disable|stats>");
                    return true;
                }
                switch (args[1].toLowerCase()) {
                    case "enable": {
                        if (this.globalForceEnable) {
                            player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eGlobal dupe is already enabled.");
                            break block21;
                        }
                        this.globalForceEnable = true;
                        player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aGlobal dupe ENABLED. All chunks are now treated as enabled.");
                        break block21;
                    }
                    case "disable": {
                        if (!this.globalForceEnable && this.enabledChunks.isEmpty()) {
                            player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eGlobal dupe is already disabled.");
                            break block21;
                        }
                        this.globalForceEnable = false;
                        this.enabledChunks.clear();
                        player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cGlobal dupe DISABLED. All chunks have been disabled.");
                        break block21;
                    }
                    case "stats": {
                        int total = this.chunkStatsMap.values().stream().mapToInt(s -> s.totalDupes).sum();
                        long uptime = this.chunkStatsMap.values().stream().mapToLong(s -> s.getActiveTime()).sum();
                        player.sendMessage("\u00a7b\u00a7l[Global StringDupe Stats]\u00a7r");
                        player.sendMessage(" - Total Duplications: " + total);
                        player.sendMessage(" - Approx. Combined Active Time: " + uptime / 20L + "s");
                        break block21;
                    }
                }
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eInvalid global subcommand. Use enable, disable, or stats.");
                break;
            }
            case "speed": {
                if (!this.isAdmin(player)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe speed <ticks>");
                    return true;
                }
                try {
                    this.dupeDelayTicks = Long.parseLong(args[1]);
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aDupe delay set to " + this.dupeDelayTicks + " ticks.");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cInvalid number.");
                }
                break;
            }
            case "chunklist": {
                if (!this.isAdmin(player)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7b\u00a7lEnabled Chunks:");
                for (String key : this.enabledChunks) {
                    int chunkZ;
                    int chunkX;
                    String[] parts = key.split(",");
                    if (parts.length != 3) continue;
                    String worldName = parts[0];
                    try {
                        chunkX = Integer.parseInt(parts[1]);
                        chunkZ = Integer.parseInt(parts[2]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    World world = Bukkit.getWorld((String)worldName);
                    if (world == null) continue;
                    int blockX = chunkX * 16 + 8;
                    int blockZ = chunkZ * 16 + 8;
                    String teleportCommand = "/tp " + player.getName() + " " + blockX + " ~ " + blockZ;
                    TextComponent clickable = new TextComponent(" - " + key + " ");
                    clickable.setColor(ChatColor.YELLOW);
                    clickable.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, teleportCommand));
                    clickable.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to teleport to this chunk").create()));
                    player.spigot().sendMessage((BaseComponent)clickable);
                }
                break;
            }
            case "tpchunk": {
                if (!this.isAdmin(player)) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cYou are not authorized to use this command.");
                    return true;
                }
                if (args.length < 4) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe tpchunk <world> <x> <z>");
                    return true;
                }
                World world = Bukkit.getWorld((String)args[1]);
                if (world == null) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cWorld not found.");
                    return true;
                }
                try {
                    int chunkX = Integer.parseInt(args[2]);
                    int chunkZ = Integer.parseInt(args[3]);
                    int blockX = chunkX * 16 + 8;
                    int blockZ = chunkZ * 16 + 8;
                    int blockY = world.getHighestBlockYAt(blockX, blockZ);
                    player.teleport(new Location(world, (double)blockX + 0.5, (double)(blockY + 1), (double)blockZ + 0.5));
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aTeleported to chunk " + chunkX + ", " + chunkZ + " in world " + world.getName() + ".");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cInvalid coordinates.");
                }
                break;
            }
            case "operator": {
                if (!player.isOp()) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cOnly operators can modify admins.");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7eUsage: /stringdupe operator <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target != null) {
                    this.approvedAdmins.add(target.getUniqueId());
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aAdded " + target.getName() + " as approved admin.");
                    break;
                }
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cPlayer not found.");
                break;
            }
            case "operators": {
                if (!player.isOp()) {
                    player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cOnly operators can use this command.");
                    return true;
                }
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7aApproved Admins:");
                for (UUID uuid : this.approvedAdmins) {
                    OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
                    player.sendMessage(" - " + p.getName());
                }
                break;
            }
            default: {
                player.sendMessage("\u00a7b\u00a7l[StringDupe]\u00a7r \u00a7cUnknown subcommand.");
            }
        }
        return true;
    }

    private int countStringItemsInSurroundingChunks(Chunk centerChunk) {
        int total = 0;
        World world = centerChunk.getWorld();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                Chunk chunk = world.getChunkAt(centerChunk.getX() + dx, centerChunk.getZ() + dz);
                for (Entity entity : chunk.getEntities()) {
                    Item item;
                    if (!(entity instanceof Item) || (item = (Item)entity).getItemStack().getType() != Material.STRING) continue;
                    total += item.getItemStack().getAmount();
                }
            }
        }
        return total;
    }

    private void updateTripwires(Block baseBlock) {
        Chunk chunk = baseBlock.getChunk();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < baseBlock.getWorld().getMaxHeight(); ++y) {
                    Block b = chunk.getBlock(x, y, z);
                    if (b.getType() != Material.TRIPWIRE) continue;
                    b.setType(Material.AIR, false);
                    Bukkit.getScheduler().runTaskLater((Plugin)this, () -> b.setType(Material.TRIPWIRE), 2L);
                }
            }
        }
    }

    private void triggerPhysicsInChunk(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < chunk.getWorld().getMaxHeight(); ++y) {
                    Block block = chunk.getBlock(x, y, z);
                    if (block.getType() != Material.TRIPWIRE) continue;
                    block.getState().update(true, true);
                }
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("enable", "disable", "status", "stats", "global", "speed", "operator", "operators", "chunkList", "proximity", "dropcap", "reload");
        }
        if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "global": {
                    return Arrays.asList("enable", "disable", "stats");
                }
                case "speed": {
                    return List.of("3");
                }
                case "operator": {
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
                }
                case "proximity": {
                    return List.of("5");
                }
                case "dropcap": {
                    return Arrays.asList("enable", "disable", "<number>");
                }
                case "autoload": {
                    return Arrays.asList("enable", "disable");
                }
            }
        }
        return Collections.emptyList();
    }

    private void loadChunkData() {
        FileConfiguration config = this.getConfig();
        List savedChunks = config.getStringList("enabledChunks");
        this.enabledChunks.clear();
        this.enabledChunks.addAll(savedChunks);
        this.autoLoadChunks = config.getBoolean("autoload", false);
    }

    private void saveChunkData() {
        FileConfiguration config = this.getConfig();
        config.set("enabledChunks", new ArrayList<String>(this.enabledChunks));
        config.set("autoload", (Object)this.autoLoadChunks);
        this.saveConfig();
    }

    private static class ChunkStats {
        int totalDupes = 0;
        long firstDupeTime = System.currentTimeMillis();

        private ChunkStats() {
        }

        void recordDuplication() {
            ++this.totalDupes;
        }

        long getActiveTime() {
            return System.currentTimeMillis() - this.firstDupeTime;
        }

        String getFormattedTime() {
            long seconds = this.getActiveTime() / 1000L;
            return seconds + "s";
        }
    }
}

