/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.cobblemontools.formats;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.roanoke.cobblemontools.CobblemonTools;
import dev.roanoke.cobblemontools.formats.CTPokemon;
import dev.roanoke.cobblemontools.utils.PokemonConversions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 .2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001.B+\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001cH\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010\"\u001a\u00020!2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u0005\u00a2\u0006\u0004\b$\u0010%R\u001c\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010&R\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010'\u001a\u0004\b(\u0010%\"\u0004\b)\u0010*R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b+\u0010%R\u0014\u0010,\u001a\u00020\u00128\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Ldev/roanoke/cobblemontools/formats/CTTeam;", "", "Ldev/roanoke/cobblemontools/formats/CTPokemon;", "", "party", "", "name", "id", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "Lnet/minecraft/class_3222;", "player", "", "give", "(Lnet/minecraft/class_3222;)V", "getTeamList", "()Ljava/util/List;", "pokemon", "", "slot", "addTeamMember", "(Ldev/roanoke/cobblemontools/formats/CTPokemon;I)V", "removeTeamMember", "(I)V", "getTeamMember", "(I)Ldev/roanoke/cobblemontools/formats/CTPokemon;", "hashCode", "()I", "", "iterator", "()Ljava/util/Iterator;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "toJsonString", "()Ljava/lang/String;", "Ljava/util/List;", "Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "getId", "MAX_SIZE", "I", "Companion", "CobblemonTools"})
public final class CTTeam
implements Iterable<CTPokemon>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<CTPokemon> party;
    @NotNull
    private String name;
    @NotNull
    private final String id;
    private final int MAX_SIZE;

    public CTTeam(@NotNull List<CTPokemon> party, @NotNull String name, @NotNull String id) {
        Intrinsics.checkNotNullParameter(party, (String)"party");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.party = party;
        this.name = name;
        this.id = id;
        this.MAX_SIZE = 6;
    }

    public /* synthetic */ CTTeam(List list, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "Default Team";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(list, string, string2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void give(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<Pokemon> team = PokemonConversions.INSTANCE.getPokemonFromTeam(CollectionsKt.filterNotNull((Iterable)this.getTeamList()));
        PlayerPartyStore party = null;
        party = Cobblemon.INSTANCE.getStorage().getParty(player);
        PCStore pc = PlayerExtensionsKt.pc((class_3222)player);
        for (Pokemon pokemon : party) {
            party.remove(pokemon);
            pc.add(pokemon);
        }
        for (Pokemon member : team) {
            party.add(member);
        }
        party.heal();
    }

    @NotNull
    public final List<CTPokemon> getTeamList() {
        return this.party;
    }

    public final void addTeamMember(@NotNull CTPokemon pokemon, int slot) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (slot < 0 || slot >= this.MAX_SIZE) {
            throw new IllegalArgumentException("Invalid slot");
        }
        this.party.set(slot, pokemon);
    }

    public final void removeTeamMember(int slot) {
        if (slot < 0 || slot >= this.MAX_SIZE) {
            throw new IllegalArgumentException("Invalid slot");
        }
        this.party.set(slot, null);
    }

    @Nullable
    public final CTPokemon getTeamMember(int slot) {
        if (slot < 0 || slot >= this.MAX_SIZE) {
            throw new IllegalArgumentException("Invalid slot");
        }
        return this.party.get(slot);
    }

    public int hashCode() {
        return ((Object)this.party).hashCode();
    }

    @Override
    @NotNull
    public Iterator<CTPokemon> iterator() {
        return this.party.iterator();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type dev.roanoke.cobblemontools.formats.CTTeam");
        CTTeam cfr_ignored_0 = (CTTeam)other;
        if (this.MAX_SIZE != ((CTTeam)other).MAX_SIZE) {
            return false;
        }
        return Intrinsics.areEqual(this.party, ((CTTeam)other).party);
    }

    @NotNull
    public final String toJsonString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)this.name), TuplesKt.to((Object)"format", (Object)"cobblemon"), TuplesKt.to((Object)"team", this.getTeamList())};
        Map teamMap = MapsKt.mapOf((Pair[])pairArray);
        return gson.toJson((Object)teamMap).toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/roanoke/cobblemontools/formats/CTTeam$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "playerParty", "Ldev/roanoke/cobblemontools/formats/CTTeam;", "fromParty", "(Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;)Ldev/roanoke/cobblemontools/formats/CTTeam;", "Lnet/minecraft/class_3222;", "player", "fromPlayerParty", "(Lnet/minecraft/class_3222;)Ldev/roanoke/cobblemontools/formats/CTTeam;", "Lcom/google/gson/JsonObject;", "json", "fromJson", "(Lcom/google/gson/JsonObject;)Ldev/roanoke/cobblemontools/formats/CTTeam;", "CobblemonTools"})
    @SourceDebugExtension(value={"SMAP\nCTTeam.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CTTeam.kt\ndev/roanoke/cobblemontools/formats/CTTeam$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1863#2:171\n1557#2:172\n1628#2,3:173\n1557#2:176\n1628#2,3:177\n1557#2:180\n1628#2,3:181\n1864#2:184\n1557#2:185\n1628#2,3:186\n*S KotlinDebug\n*F\n+ 1 CTTeam.kt\ndev/roanoke/cobblemontools/formats/CTTeam$Companion\n*L\n58#1:171\n73#1:172\n73#1:173,3\n76#1:176\n76#1:177,3\n78#1:180\n78#1:181,3\n58#1:184\n90#1:185\n90#1:186,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CTTeam fromParty(@NotNull PlayerPartyStore playerParty) {
            Intrinsics.checkNotNullParameter((Object)playerParty, (String)"playerParty");
            List party = new ArrayList();
            for (int i = 0; i < 6; ++i) {
                Pokemon pokemon = playerParty.get(i);
                boolean bl = pokemon == null ? party.add(null) : party.add(PokemonConversions.INSTANCE.getDataFromPokemon(pokemon));
            }
            return new CTTeam(party, null, null, 6, null);
        }

        @NotNull
        public final CTTeam fromPlayerParty(@NotNull class_3222 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PlayerPartyStore playerParty = null;
            playerParty = Cobblemon.INSTANCE.getStorage().getParty(player);
            return this.fromParty(playerParty);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final CTTeam fromJson(@NotNull JsonObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            try {
                void $this$mapTo$iv$iv;
                JsonArray teamArray = json.get("team").getAsJsonArray();
                String teamID = json.get("id").getAsString();
                String teamName = json.get("name").getAsString();
                List team = new ArrayList();
                Intrinsics.checkNotNull((Object)teamArray);
                Iterable $this$forEach$iv = (Iterable)teamArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement jsonElement = (JsonElement)element$iv;
                    boolean bl = false;
                    try {
                        String string;
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        String string6;
                        void $this$mapTo$iv$iv2;
                        void $this$mapTo$iv$iv3;
                        Collection collection;
                        Object object;
                        void $this$mapTo$iv$iv4;
                        JsonObject teamMemberObject = jsonElement.getAsJsonObject();
                        int friendship = 255;
                        if (teamMemberObject.has("happiness")) {
                            friendship = teamMemberObject.get("happiness").getAsInt();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)teamMemberObject.get("ability").getAsString(), (String)"getAsString(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)teamMemberObject.get("item").getAsString(), (String)"getAsString(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)teamMemberObject.get("ball").getAsString(), (String)"getAsString(...)");
                        JsonArray jsonArray = teamMemberObject.getAsJsonArray("evs");
                        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                        Iterable $this$map$iv = (Iterable)jsonArray;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                            void it;
                            object = (JsonElement)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.getAsInt());
                        }
                        List list = (List)destination$iv$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)teamMemberObject.get("form").getAsString(), (String)"getAsString(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)teamMemberObject.get("gender").getAsString(), (String)"getAsString(...)");
                        JsonArray jsonArray2 = teamMemberObject.getAsJsonArray("ivs");
                        Intrinsics.checkNotNullExpressionValue((Object)jsonArray2, (String)"getAsJsonArray(...)");
                        Iterable $this$map$iv2 = (Iterable)jsonArray2;
                        boolean $i$f$map2 = false;
                        Object object2 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo22 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                            void it;
                            JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            collection.add(it.getAsInt());
                        }
                        iterable = (List)destination$iv$iv2;
                        int n = teamMemberObject.get("level").getAsInt();
                        JsonArray jsonArray3 = teamMemberObject.getAsJsonArray("moves");
                        Intrinsics.checkNotNullExpressionValue((Object)jsonArray3, (String)"getAsJsonArray(...)");
                        Iterable $this$map$iv3 = (Iterable)jsonArray3;
                        boolean $i$f$map3 = false;
                        Iterable $i$f$mapTo22 = $this$map$iv3;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                        boolean $i$f$mapTo3 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it;
                            JsonElement jsonElement3 = (JsonElement)item$iv$iv;
                            collection = destination$iv$iv3;
                            boolean bl4 = false;
                            collection.add(it.getAsString());
                        }
                        List list2 = (List)destination$iv$iv3;
                        String string7 = teamMemberObject.get("nature").getAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAsString(...)");
                        object2 = string7;
                        Intrinsics.checkNotNullExpressionValue((Object)teamMemberObject.get("shiny").getAsString(), (String)"getAsString(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)teamMemberObject.get("species").getAsString(), (String)"getAsString(...)");
                        int n2 = friendship;
                        CTPokemon teamMember = new CTPokemon((String)object, string6, string5, string4, n, n2, string3, (String)object2, string2, string, (List<Integer>)iterable, list, list2);
                        team.add(teamMember);
                    }
                    catch (Exception e) {
                        team.add(null);
                    }
                }
                Iterable $this$map$iv = team;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CTPokemon e = (CTPokemon)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it);
                }
                List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                Intrinsics.checkNotNull((Object)teamName);
                Intrinsics.checkNotNull((Object)teamID);
                String string = teamID;
                String string8 = teamName;
                List list3 = list;
                return new CTTeam(list3, string8, string);
            }
            catch (Exception e) {
                CobblemonTools.Companion.getLOGGER().error("Failed to load team: ", (Throwable)e);
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

