/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.cobblemontools;

import com.cobblemon.mod.common.api.reactive.Observable;
import dev.roanoke.cobblemontools.battle.BattleEvents;
import dev.roanoke.cobblemontools.commands.CTCommandRegistration;
import dev.roanoke.cobblemontools.events.BattleReplayUpload;
import dev.roanoke.cobblemontools.events.CTEvents;
import dev.roanoke.cobblemontools.utils.Config;
import dev.roanoke.rib.Rib;
import dev.roanoke.rib.messages.FileBackedMessages;
import dev.roanoke.rib.messages.Messages;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0007"}, d2={"Ldev/roanoke/cobblemontools/CobblemonTools;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Companion", "CobblemonTools"})
@SourceDebugExtension(value={"SMAP\nCobblemonTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonTools.kt\ndev/roanoke/cobblemontools/CobblemonTools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1869#2,2:61\n*S KotlinDebug\n*F\n+ 1 CobblemonTools.kt\ndev/roanoke/cobblemontools/CobblemonTools\n*L\n42#1:61,2\n*E\n"})
public final class CobblemonTools
implements ModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MODID = "cobblemontools";
    private static final Path MAIN_DIR = FabricLoader.getInstance().getConfigDir().resolve(MODID);
    @NotNull
    private static final String CONFIG_PATH = "config/" + MODID + "/main.json";
    @NotNull
    private static Messages MESSAGES;
    @NotNull
    private static Config CONFIG;
    @NotNull
    private static final Logger LOGGER;

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register(CTCommandRegistration.INSTANCE::register);
        BattleEvents.INSTANCE.register();
        Observable.subscribe$default((Observable)((Observable)CTEvents.INSTANCE.getBATTLE_REPLAY_UPLOADED()), null, CobblemonTools::onInitialize$lambda$1, (int)1, null);
    }

    private static final Unit onInitialize$lambda$1(BattleReplayUpload it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (CONFIG.getShareReplaysAfterBattle()) {
            Iterable $this$forEach$iv = it.participants();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                Rib.MESSENGER.send(uuid, MESSAGES.getMessage("battle_replay", it.placeholders()));
            }
        }
        if (CONFIG.getAnnounceReplaysAfterBattle()) {
            Rib.MESSENGER.announce(MESSAGES.getMessage("battle_replay_announcement", it.placeholders()), true);
        }
        return Unit.INSTANCE;
    }

    static {
        Path path = MAIN_DIR.resolve("messages.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        MESSAGES = (Messages)new FileBackedMessages(path, "/cobblemontools/messages.json");
        CONFIG = Config.Companion.load(new File(CONFIG_PATH));
        Logger logger = LoggerFactory.getLogger((String)"CobblemonTools");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u0010\u0010\bR\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Ldev/roanoke/cobblemontools/CobblemonTools$Companion;", "", "<init>", "()V", "", "MODID", "Ljava/lang/String;", "getMODID", "()Ljava/lang/String;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "MAIN_DIR", "Ljava/nio/file/Path;", "getMAIN_DIR", "()Ljava/nio/file/Path;", "CONFIG_PATH", "getCONFIG_PATH", "Ldev/roanoke/rib/messages/Messages;", "MESSAGES", "Ldev/roanoke/rib/messages/Messages;", "getMESSAGES", "()Ldev/roanoke/rib/messages/Messages;", "setMESSAGES", "(Ldev/roanoke/rib/messages/Messages;)V", "Ldev/roanoke/cobblemontools/utils/Config;", "CONFIG", "Ldev/roanoke/cobblemontools/utils/Config;", "getCONFIG", "()Ldev/roanoke/cobblemontools/utils/Config;", "setCONFIG", "(Ldev/roanoke/cobblemontools/utils/Config;)V", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "CobblemonTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMODID() {
            return MODID;
        }

        public final Path getMAIN_DIR() {
            return MAIN_DIR;
        }

        @NotNull
        public final String getCONFIG_PATH() {
            return CONFIG_PATH;
        }

        @NotNull
        public final Messages getMESSAGES() {
            return MESSAGES;
        }

        public final void setMESSAGES(@NotNull Messages messages) {
            Intrinsics.checkNotNullParameter((Object)messages, (String)"<set-?>");
            MESSAGES = messages;
        }

        @NotNull
        public final Config getCONFIG() {
            return CONFIG;
        }

        public final void setCONFIG(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
            CONFIG = config;
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

