/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.cobblemontools.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.roanoke.cobblemontools.CobblemonTools;
import dev.roanoke.cobblemontools.formats.CTTeam;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0086@\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0004\b\u0015\u0010\bJ\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Ldev/roanoke/cobblemontools/utils/CobblemonToolsAPI;", "", "<init>", "()V", "", "teamID", "Ldev/roanoke/cobblemontools/formats/CTTeam;", "getTeamById", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/util/concurrent/CompletableFuture;", "getTeamByIdJava", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Lkotlinx/serialization/json/JsonObject;", "json", "Lkotlin/Pair;", "uploadBattle", "(Lkotlinx/serialization/json/JsonObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "team", "uploadTeam", "(Ldev/roanoke/cobblemontools/formats/CTTeam;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pokepasteUrl", "pokePasteToTeamID", "pokePasteToCTTeam", "CobblemonTools"})
public final class CobblemonToolsAPI {
    @NotNull
    public static final CobblemonToolsAPI INSTANCE = new CobblemonToolsAPI();

    private CobblemonToolsAPI() {
    }

    @Nullable
    public final Object getTeamById(@NotNull String teamID, @NotNull Continuation<? super CTTeam> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CTTeam>, Object>(teamID, null){
            int label;
            final /* synthetic */ String $teamID;
            {
                this.$teamID = $teamID;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        ResultKt.throwOnFailure((Object)object);
                        String urlString = CobblemonTools.Companion.getCONFIG().getCobblemonToolsURL() + "/api/v1/teams/" + this.$teamID;
                        CobblemonTools.Companion.getLOGGER().info("Trying to get Cobblemon Tools Team from URL: " + urlString);
                        try {
                            Object object3;
                            URL url = new URL(urlString);
                            Object object4 = url.openConnection();
                            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection con = (HttpURLConnection)object4;
                            con.setRequestMethod("GET");
                            if (con.getResponseCode() == 200) {
                                object4 = con.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getInputStream(...)");
                                Charset charset = StandardCharsets.UTF_8;
                                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                                Object object5 = charset;
                                object3 = new InputStreamReader((InputStream)object4, (Charset)object5);
                                int n = 8192;
                                object4 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                                object5 = null;
                                try {
                                    CTTeam cTTeam;
                                    BufferedReader reader = (BufferedReader)object4;
                                    boolean bl = false;
                                    String response = TextStreamsKt.readText((Reader)reader);
                                    CobblemonTools.Companion.getLOGGER().info("Response: " + response);
                                    JsonObject responseJson = JsonParser.parseString((String)response).getAsJsonObject();
                                    if (responseJson.has("name")) {
                                        Intrinsics.checkNotNull((Object)responseJson);
                                        cTTeam = CTTeam.Companion.fromJson(responseJson);
                                    } else {
                                        CobblemonTools.Companion.getLOGGER().info("Incorrect Response type from Cobblemon Tools: No Name Key. Check the Team ID is valid!");
                                        cTTeam = null;
                                    }
                                    object3 = cTTeam;
                                }
                                catch (Throwable throwable) {
                                    object5 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object4, (Throwable)object5);
                                }
                            } else {
                                throw new IOException("GET request failed, response code: " + con.getResponseCode());
                            }
                            object2 = object3;
                        }
                        catch (IOException e) {
                            CobblemonTools.Companion.getLOGGER().error("IO Exception when fetching Cobblemon Tools Team, is Cobblemon Tools up?", (Throwable)e);
                            object2 = null;
                        }
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CTTeam> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final CompletableFuture<CTTeam> getTeamByIdJava(@NotNull String teamID) {
        Intrinsics.checkNotNullParameter((Object)teamID, (String)"teamID");
        CompletableFuture<CTTeam> completableFuture = CompletableFuture.supplyAsync(() -> CobblemonToolsAPI.getTeamByIdJava$lambda$0(teamID));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @Nullable
    public final Object uploadBattle(@NotNull kotlinx.serialization.json.JsonObject json, @NotNull Continuation<? super Pair<String, String>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends String, ? extends String>>, Object>(json, null){
            int label;
            final /* synthetic */ kotlinx.serialization.json.JsonObject $json;
            {
                this.$json = $json;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        ResultKt.throwOnFailure((Object)object);
                        String urlString = CobblemonTools.Companion.getCONFIG().getCobblemonToolsURL() + "/api/v1/replays";
                        try {
                            URL url = new URL(urlString);
                            Object object3 = url.openConnection();
                            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection con = (HttpURLConnection)object3;
                            con.setRequestMethod("POST");
                            con.setRequestProperty("Content-Type", "application/json; utf-8");
                            con.setRequestProperty("Accept", "application/json");
                            con.setDoOutput(true);
                            object3 = new OutputStreamWriter(con.getOutputStream(), StandardCharsets.UTF_8);
                            Object object4 = this.$json;
                            Object object5 = null;
                            try {
                                OutputStreamWriter writer = (OutputStreamWriter)object3;
                                boolean bl = false;
                                StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
                                boolean $i$f$encodeToString = false;
                                SerializersModule serializersModule = $this$encodeToString$iv.getSerializersModule();
                                KType kType = Reflection.typeOf(kotlinx.serialization.json.JsonObject.class);
                                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                                writer.write($this$encodeToString$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), object4));
                                writer.flush();
                                writer = Unit.INSTANCE;
                            }
                            catch (Throwable bl) {
                                object5 = bl;
                                throw bl;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object3, (Throwable)object5);
                            }
                            if (con.getResponseCode() == 200) {
                                object3 = con.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getInputStream(...)");
                                Charset charset = StandardCharsets.UTF_8;
                                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                                object4 = charset;
                                object5 = new InputStreamReader((InputStream)object3, (Charset)object4);
                                int writer = 8192;
                                object3 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, writer);
                                object4 = null;
                                try {
                                    Pair pair;
                                    BufferedReader reader = (BufferedReader)object3;
                                    boolean bl = false;
                                    String response = TextStreamsKt.readText((Reader)reader);
                                    JsonObject responseJson = JsonParser.parseString((String)response).getAsJsonObject();
                                    if (responseJson.has("battle_url")) {
                                        String battleUrl = CobblemonTools.Companion.getCONFIG().getCobblemonToolsURL() + responseJson.get("battle_url").getAsString();
                                        String battleUrlWithTeams = CobblemonTools.Companion.getCONFIG().getCobblemonToolsURL() + responseJson.get("battle_url_with_teams").getAsString();
                                        pair = new Pair((Object)battleUrl, (Object)battleUrlWithTeams);
                                    } else {
                                        CobblemonTools.Companion.getLOGGER().info("Failed to upload Battle to Cobblemon Tools...");
                                        pair = null;
                                    }
                                    object5 = pair;
                                }
                                catch (Throwable throwable) {
                                    object4 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                                }
                            } else {
                                throw new IOException("POST request failed, response code: " + con.getResponseCode());
                            }
                            object2 = object5;
                        }
                        catch (IOException e) {
                            CobblemonTools.Companion.getLOGGER().error("IO Exception when trying to upload Battle Replay, is Cobblemon Tools up?", (Throwable)e);
                            object2 = null;
                        }
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<String, String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object uploadTeam(@NotNull CTTeam team, @NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(team, null){
            int label;
            final /* synthetic */ CTTeam $team;
            {
                this.$team = $team;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        ResultKt.throwOnFailure((Object)object);
                        String urlString = CobblemonTools.Companion.getCONFIG().getCobblemonToolsURL() + "/api/v1/teams";
                        CobblemonTools.Companion.getLOGGER().info("Trying to create Cobblemon Tools Team with URL: " + urlString);
                        try {
                            URL url = new URL(urlString);
                            Object object3 = url.openConnection();
                            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection con = (HttpURLConnection)object3;
                            con.setRequestMethod("POST");
                            con.setRequestProperty("Content-Type", "application/json; utf-8");
                            con.setRequestProperty("Accept", "application/json");
                            con.setDoOutput(true);
                            object3 = new OutputStreamWriter(con.getOutputStream(), StandardCharsets.UTF_8);
                            Object object4 = this.$team;
                            Object object5 = null;
                            try {
                                OutputStreamWriter writer = (OutputStreamWriter)object3;
                                boolean bl = false;
                                writer.write(((CTTeam)object4).toJsonString());
                                writer.flush();
                                writer = Unit.INSTANCE;
                            }
                            catch (Throwable bl) {
                                object5 = bl;
                                throw bl;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object3, (Throwable)object5);
                            }
                            if (con.getResponseCode() == 200) {
                                object3 = con.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getInputStream(...)");
                                Charset charset = StandardCharsets.UTF_8;
                                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                                object4 = charset;
                                object5 = new InputStreamReader((InputStream)object3, (Charset)object4);
                                int writer = 8192;
                                object3 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, writer);
                                object4 = null;
                                try {
                                    String string;
                                    BufferedReader reader = (BufferedReader)object3;
                                    boolean bl = false;
                                    String response = TextStreamsKt.readText((Reader)reader);
                                    JsonObject responseJson = JsonParser.parseString((String)response).getAsJsonObject();
                                    if (responseJson.has("team_url")) {
                                        string = CobblemonTools.Companion.getCONFIG().getCobblemonToolsURL() + responseJson.get("team_url").getAsString();
                                    } else {
                                        CobblemonTools.Companion.getLOGGER().info("Failed to upload Team to Cobblemon Tools...");
                                        string = null;
                                    }
                                    object5 = string;
                                }
                                catch (Throwable throwable) {
                                    object4 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                                }
                            } else {
                                throw new IOException("POST request failed, response code: " + con.getResponseCode());
                            }
                            object2 = object5;
                        }
                        catch (IOException e) {
                            CobblemonTools.Companion.getLOGGER().error("IO Exception when trying to create Cobblemon Tools Team, is Cobblemon Tools up?", (Throwable)e);
                            object2 = null;
                        }
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object pokePasteToTeamID(@NotNull String pokepasteUrl, @NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(pokepasteUrl, null){
            int label;
            final /* synthetic */ String $pokepasteUrl;
            {
                this.$pokepasteUrl = $pokepasteUrl;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure((Object)object);
                        String urlString = CobblemonTools.Companion.getCONFIG().getCobblemonToolsURL() + "/api/v1/teams";
                        CobblemonTools.Companion.getLOGGER().info("Trying to convert PokePaste ({" + this.$pokepasteUrl + "}) to Cobblemoon Tools Team. Posting to: " + urlString);
                        try {
                            String string2;
                            int n2;
                            Closeable writer;
                            URL url = new URL(urlString);
                            URLConnection uRLConnection = url.openConnection();
                            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection con = (HttpURLConnection)uRLConnection;
                            con.setRequestMethod("POST");
                            con.setRequestProperty("Content-Type", "application/json; utf-8");
                            con.setRequestProperty("Accept", "application/json");
                            con.setDoOutput(true);
                            Gson gson = new GsonBuilder().setPrettyPrinting().create();
                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"format", (Object)"pokepaste"), TuplesKt.to((Object)"pokepaste", (Object)this.$pokepasteUrl)};
                            Map data = MapsKt.mapOf((Pair[])pairArray);
                            String payload = gson.toJson((Object)data).toString();
                            Closeable closeable = new OutputStreamWriter(con.getOutputStream(), StandardCharsets.UTF_8);
                            Object object2 = null;
                            try {
                                writer = (OutputStreamWriter)closeable;
                                n2 = 0;
                                writer.write(payload);
                                writer.flush();
                                writer = Unit.INSTANCE;
                            }
                            catch (Throwable n2) {
                                object2 = n2;
                                throw n2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                            }
                            if (con.getResponseCode() == 200) {
                                closeable = con.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"getInputStream(...)");
                                Charset charset = StandardCharsets.UTF_8;
                                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                                object2 = charset;
                                writer = new InputStreamReader((InputStream)closeable, (Charset)object2);
                                n2 = 8192;
                                closeable = writer instanceof BufferedReader ? (BufferedReader)writer : new BufferedReader((Reader)writer, n2);
                                object2 = null;
                                try {
                                    String string3;
                                    BufferedReader reader = (BufferedReader)closeable;
                                    boolean bl = false;
                                    String response = TextStreamsKt.readText((Reader)reader);
                                    JsonObject responseJson = JsonParser.parseString((String)response).getAsJsonObject();
                                    if (responseJson.has("team_id")) {
                                        string3 = responseJson.get("team_id").getAsString();
                                    } else {
                                        CobblemonTools.Companion.getLOGGER().info("Failed to convert PokePaste to Cobblemon Tools Format...");
                                        string3 = null;
                                    }
                                    string2 = string3;
                                }
                                catch (Throwable throwable) {
                                    object2 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                                }
                            } else {
                                throw new IOException("POST request failed, response code: " + con.getResponseCode());
                            }
                            string = string2;
                        }
                        catch (IOException e) {
                            CobblemonTools.Companion.getLOGGER().error("IO Exception when trying to convert PokePaste, is Cobblemon Tools up?", (Throwable)e);
                            string = null;
                        }
                        return string;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object pokePasteToCTTeam(@NotNull String pokepasteUrl, @NotNull Continuation<? super CTTeam> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CTTeam>, Object>(pokepasteUrl, null){
            int label;
            final /* synthetic */ String $pokepasteUrl;
            {
                this.$pokepasteUrl = $pokepasteUrl;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CobblemonToolsAPI.INSTANCE.pokePasteToTeamID(this.$pokepasteUrl, (Continuation<? super String>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((team_id = (String)v0) == null) {
                            CobblemonTools.Companion.getLOGGER().error("Failed to convert PokePaste to Cobblemon Tools Team...");
                        }
                        v1 = team_id;
                        Intrinsics.checkNotNull((Object)v1);
                        this.label = 2;
                        v2 = CobblemonToolsAPI.INSTANCE.getTeamById(v1, (Continuation<? super CTTeam>)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl25:
                        // 2 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CTTeam> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final CTTeam getTeamByIdJava$lambda$0(String $teamID) {
        return (CTTeam)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CTTeam>, Object>($teamID, null){
            int label;
            final /* synthetic */ String $teamID;
            {
                this.$teamID = $teamID;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CobblemonToolsAPI.INSTANCE.getTeamById(this.$teamID, (Continuation<? super CTTeam>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CTTeam> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }
}

