/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.CorpseMod;
import de.maxhenkel.corpse.corelib.inventory.ItemListInventory;
import de.maxhenkel.corpse.corelib.inventory.LockedSlot;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.ITransferrable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.PlayerInventoryWrapper;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class CorpseAdditionalContainer
extends CorpseContainerBase
implements ITransferrable {
    private final PlayerInventoryWrapper playerWrapper;

    public CorpseAdditionalContainer(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history) {
        super((MenuType)CorpseMod.CONTAINER_TYPE_CORPSE_ADDITIONAL_ITEMS.get(), id, playerInventory, corpse, editable, history);
        this.inventory = new ItemListInventory(corpse.getDeath().getAdditionalItems());
        this.playerWrapper = PlayerInventoryWrapper.of((Inventory)playerInventory);
        this.setSlots(0);
    }

    public void setSlots(int start) {
        this.slots.clear();
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 9; ++k) {
                int index = start + k + j * 9;
                if (index < this.inventory.getContainerSize()) {
                    this.addSlot(new LockedSlot(this.inventory, index, 8 + k * 18, 19 + j * 18, true, !this.editable));
                    continue;
                }
                this.addSlot(new LockedSlot((Container)new SimpleContainer(1), 0, 8 + k * 18, 19 + j * 18, true, true));
            }
        }
        this.addPlayerInventorySlots();
        this.broadcastChanges();
    }

    @Override
    public void transferItems() {
        if (!this.isEditable()) {
            return;
        }
        try (Transaction transaction = Transaction.open(null);){
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack stack = this.inventory.getItem(i);
                int inserted = this.playerWrapper.insert(ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)transaction);
                int invAmount = stack.getCount() - inserted;
                if (invAmount <= 0) {
                    this.inventory.setItem(i, ItemStack.EMPTY);
                    continue;
                }
                this.inventory.setItem(i, stack.split(invAmount));
            }
            transaction.commit();
        }
    }

    @Override
    public int getInvOffset() {
        return 82;
    }

    @Override
    public int getInventorySize() {
        return 54;
    }
}

