/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import de.maxhenkel.corpse.net.MessageOpenAdditionalItems;
import de.maxhenkel.corpse.net.MessageTransferItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class CorpseInventoryScreen
extends ScreenBase<CorpseInventoryContainer> {
    public static final Identifier CORPSE_GUI_TEXTURE = Identifier.fromNamespaceAndPath((String)"corpse", (String)"textures/gui/inventory_corpse.png");
    public static final MutableComponent TRANSFER_ITEMS = Component.translatable((String)"button.corpse.transfer_items");
    public static final MutableComponent ADDITIONAL_ITEMS = Component.translatable((String)"button.corpse.additional_items");
    public static final Button.OnPress PRESS_TRANSFER_ITEMS = b -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageTransferItems(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    public static final Button.OnPress PRESS_ADDITIONAL_ITEMS = b -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageOpenAdditionalItems(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    private static final int PADDING = 7;
    private static final int BUTTON_HEIGHT = 20;
    private Inventory playerInventory;
    private CorpseEntity corpse;
    private Button takeItems;
    private Button additionalItems;

    public CorpseInventoryScreen(CorpseEntity corpse, Inventory playerInventory, CorpseInventoryContainer container, Component title) {
        super(CORPSE_GUI_TEXTURE, container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.corpse = corpse;
        this.imageWidth = 176;
        this.imageHeight = 245;
    }

    protected void containerTick() {
        super.containerTick();
        this.updateButtons();
    }

    public void init() {
        super.init();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.clearWidgets();
        CorpseEntity corpse = ((CorpseInventoryContainer)this.menu).getCorpse();
        if (!corpse.isMainInventoryEmpty() && !corpse.isAdditionalInventoryEmpty()) {
            this.takeItems = this.addLeftButton((Component)TRANSFER_ITEMS, PRESS_TRANSFER_ITEMS);
            this.additionalItems = this.addRightButton((Component)ADDITIONAL_ITEMS, PRESS_ADDITIONAL_ITEMS);
        } else if (!corpse.isMainInventoryEmpty()) {
            this.takeItems = this.addCenterButton((Component)TRANSFER_ITEMS, PRESS_TRANSFER_ITEMS);
            this.additionalItems = null;
        } else if (!corpse.isAdditionalInventoryEmpty()) {
            this.takeItems = null;
            this.additionalItems = this.addCenterButton((Component)ADDITIONAL_ITEMS, PRESS_ADDITIONAL_ITEMS);
        }
        if (this.takeItems != null) {
            this.takeItems.active = ((CorpseInventoryContainer)this.menu).isEditable();
        }
    }

    private Button addLeftButton(Component text, Button.OnPress pressable) {
        return (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)text, (Button.OnPress)pressable).bounds(this.leftPos + 7, this.topPos + 120, 80, 20).build());
    }

    private Button addRightButton(Component text, Button.OnPress pressable) {
        return (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)text, (Button.OnPress)pressable).bounds(this.leftPos + this.imageWidth - 80 - 7, this.topPos + 120, 80, 20).build());
    }

    private Button addCenterButton(Component text, Button.OnPress pressable) {
        return (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)text, (Button.OnPress)pressable).bounds(this.leftPos + this.imageWidth / 2 - 50, this.topPos + 120, 100, 20).build());
    }

    @Override
    public void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.corpse.getDisplayName(), 7, 7, -12566464, false);
        guiGraphics.drawString(this.font, this.playerInventory.getDisplayName(), 7, this.imageHeight - 96 + 2, -12566464, false);
    }
}

