/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageSwitchInventoryPage
implements Message<MessageSwitchInventoryPage> {
    public static final CustomPacketPayload.Type<MessageSwitchInventoryPage> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"corpse", (String)"switch_inventory_page"));
    private int page;

    public MessageSwitchInventoryPage() {
    }

    public MessageSwitchInventoryPage(int page) {
        this.page = page;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (abstractContainerMenu instanceof CorpseAdditionalContainer) {
            CorpseAdditionalContainer containerCorpse = (CorpseAdditionalContainer)abstractContainerMenu;
            containerCorpse.setSlots(this.page * 54);
        }
    }

    @Override
    public MessageSwitchInventoryPage fromBytes(RegistryFriendlyByteBuf buf) {
        this.page = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.page);
    }

    @Override
    public CustomPacketPayload.Type<MessageSwitchInventoryPage> type() {
        return TYPE;
    }
}

