/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.net.ClientNetworking;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageSpawnDeathParticles
implements Message<MessageSpawnDeathParticles> {
    public static final CustomPacketPayload.Type<MessageSpawnDeathParticles> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"spawn_death_particles"));
    private UUID corpseUUID;

    public MessageSpawnDeathParticles() {
    }

    public MessageSpawnDeathParticles(UUID corpseUUID) {
        this.corpseUUID = corpseUUID;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(IPayloadContext context) {
        ClientNetworking.spawnParticles(this.corpseUUID);
    }

    @Override
    public MessageSpawnDeathParticles fromBytes(RegistryFriendlyByteBuf buf) {
        this.corpseUUID = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.corpseUUID);
    }

    @Override
    public CustomPacketPayload.Type<MessageSpawnDeathParticles> type() {
        return TYPE;
    }
}

