/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.internal.editor.yaml;

import de.leonhard.storage.util.FileUtils;
import de.leonhard.storage.util.YamlUtils;
import java.io.File;
import java.util.List;

public class YamlEditor {
    private final File file;

    public List<String> read() {
        return FileUtils.readAllLines(this.file);
    }

    public List<String> readKeys() {
        return YamlUtils.getKeys(this.read());
    }

    public List<String> readComments() {
        return YamlUtils.getKeys(this.read());
    }

    public List<String> readHeader() {
        return YamlUtils.getHeaderFromLines(this.read());
    }

    public List<String> readFooter() {
        return YamlUtils.getFooterFromLines(this.read());
    }

    public List<String> readPureComments() {
        return YamlUtils.getPureCommentsFromLines(this.read());
    }

    public List<String> readWithoutHeaderAndFooter() {
        return YamlUtils.getLinesWithoutFooterAndHeaderFromLines(this.read());
    }

    public void write(List<String> lines) {
        FileUtils.write(this.file, lines);
    }

    public void setHeader(List<String> header) {
        List<String> lines = this.read();
        lines.removeAll(this.readHeader());
        for (int i = 0; i < header.size(); ++i) {
            String toAdd = header.get(i);
            lines.add(i, toAdd.startsWith("#") ? toAdd : "#" + toAdd);
        }
        this.write(lines);
    }

    public void addHeader(List<String> header) {
        List<String> lines = this.read();
        for (int i = 0; i < header.size(); ++i) {
            String toAdd = header.get(i);
            lines.add(i, toAdd.startsWith("#") ? toAdd : "#" + toAdd);
        }
        this.write(lines);
    }

    public File getFile() {
        return this.file;
    }

    public YamlEditor(File file) {
        this.file = file;
    }
}

