/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.bungeecord;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.greitan.avion.bungeecord.commands.VoiceCommand;
import io.greitan.avion.bungeecord.listeners.PlayerJoinHandler;
import io.greitan.avion.bungeecord.listeners.PlayerQuitHandler;
import io.greitan.avion.bungeecord.listeners.PluginMessageHandler;
import io.greitan.avion.bungeecord.tasks.PositionsTask;
import io.greitan.avion.bungeecord.utils.BungeecordLogger;
import io.greitan.avion.bungeecord.utils.Language;
import io.greitan.avion.common.BaseGeyserVoice;
import io.greitan.avion.common.network.Network;
import io.greitan.avion.common.network.Payloads;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class GeyserVoice
extends Plugin
implements BaseGeyserVoice {
    private static Configuration config;
    private static GeyserVoice instance;
    private boolean isConnected = false;
    private String host = "";
    private int port = 0;
    private String serverKey = "";
    private Map<String, Boolean> playerBinds = new HashMap<String, Boolean>();
    private String token = "";
    private String lang;
    private PluginMessageHandler messageHandler = new PluginMessageHandler(this);
    public Map<String, Payloads.PlayerData> playerDataList = new HashMap<String, Payloads.PlayerData>();
    private ScheduledTask taskRunner;
    public BungeecordLogger Logger = new BungeecordLogger();
    public Network network = new Network(this.Logger);
    public static final ObjectMapper objectMapper;

    public void onEnable() {
        instance = this;
        this.reloadConfig();
        this.lang = GeyserVoice.getConfig().getString("config.lang");
        int positionTaskInterval = GeyserVoice.getConfig().getInt("config.voice.position-task-interval", 1);
        Language.init(this);
        this.getProxy().registerChannel("geyservoice:main");
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this.messageHandler);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new VoiceCommand(this, this.lang));
        this.taskRunner = this.getProxy().getScheduler().schedule((Plugin)this, (Runnable)new PositionsTask(this, this.lang), 1L, (long)(50 * positionTaskInterval), TimeUnit.MILLISECONDS);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerJoinHandler(this, this.lang));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerQuitHandler(this, this.lang));
        this.reload();
    }

    public void onDisable() {
        this.getProxy().unregisterChannel("geyservoice:main");
        this.taskRunner.cancel();
    }

    @Override
    public void reload() {
        this.reloadConfig();
        this.Logger.info(Language.getMessage(this.lang, "plugin-config-loaded"));
        this.Logger.info(Language.getMessage(this.lang, "plugin-command-executor"));
        this.host = GeyserVoice.getConfig().getString("config.host");
        this.port = GeyserVoice.getConfig().getInt("config.port");
        this.serverKey = GeyserVoice.getConfig().getString("config.server-key");
        if (GeyserVoice.getConfig().getBoolean("config.auto-reconnect")) {
            this.isConnected = this.reconnect(true);
        }
        int positionTaskInterval = GeyserVoice.getConfig().getInt("config.voice.position-task-interval", 1);
        this.taskRunner.cancel();
        this.taskRunner = this.getProxy().getScheduler().schedule((Plugin)this, (Runnable)new PositionsTask(this, this.lang), 1L, (long)(50 * positionTaskInterval), TimeUnit.MILLISECONDS);
        int proximityDistance = GeyserVoice.getConfig().getInt("config.voice.proximity-distance");
        Boolean proximityToggle = GeyserVoice.getConfig().getBoolean("config.voice.proximity-toggle");
        Boolean voiceEffects = GeyserVoice.getConfig().getBoolean("config.voice.voice-effects");
        this.updateSettings(proximityDistance, proximityToggle, voiceEffects);
    }

    @Override
    public Boolean connect(String host, int port, String serverKey) {
        if (Objects.nonNull(host) && Objects.nonNull(serverKey)) {
            GeyserVoice.getConfig().set("config.host", (Object)host);
            GeyserVoice.getConfig().set("config.port", (Object)port);
            GeyserVoice.getConfig().set("config.server-key", (Object)serverKey);
            this.saveConfig();
            this.reloadConfig();
            this.reload();
            return this.isConnected;
        }
        this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-invalid-data"));
        return false;
    }

    @Override
    public Boolean reconnect(Boolean force) {
        if (this.isConnected && !force.booleanValue()) {
            return true;
        }
        if (this.isConnected) {
            this.disconnect("Reconnecting to another server.");
        }
        if (Objects.nonNull(this.host) && Objects.nonNull(this.serverKey)) {
            String link = "http://" + this.host + ":" + this.port;
            String Token2 = this.network.sendLoginRequest(link, this.serverKey);
            if (Objects.nonNull(Token2)) {
                this.Logger.info(Language.getMessage(this.lang, "plugin-connect-connected"));
                this.isConnected = true;
                this.token = Token2;
            } else {
                this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-failed"));
            }
            return this.isConnected;
        }
        this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-invalid-data"));
        return false;
    }

    @Override
    public void disconnect(String reason) {
        if (!this.isConnected) {
            return;
        }
        if (Objects.nonNull(this.host) && Objects.nonNull(this.serverKey)) {
            String link = "http://" + this.host + ":" + this.port;
            this.network.sendLogoutRequest(link, this.token);
            this.isConnected = false;
            String disconnectMessage = Language.getMessage(this.lang, "plugin-connection-disconnect").replace("$reason", reason);
            this.Logger.info(disconnectMessage);
            boolean sendVoipDisconnectMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-voip-disconnect-message");
            if (sendVoipDisconnectMessage) {
                this.getProxy().broadcast(new ComponentBuilder(disconnectMessage).color(ChatColor.YELLOW).create());
            }
        } else {
            this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-invalid-data"));
        }
    }

    @Override
    public void disconnect() {
        this.disconnect("N.A.");
    }

    public Boolean bind(int playerKey, ProxiedPlayer player, int tries) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        if (this.playerBinds.containsKey(player.getName()) && this.playerBinds.get(player.getName()).booleanValue()) {
            return true;
        }
        String link = "http://" + this.host + ":" + this.port;
        GeyserVoice.getConfig().set("config.players." + player.getName(), (Object)playerKey);
        this.saveConfig();
        String result = this.network.sendBindRequest(link, this.token, playerKey, player.getUniqueId().toString(), player.getName());
        this.playerBinds.put(player.getName(), false);
        if (result != null) {
            if (result == "SUCCESS") {
                this.playerBinds.put(player.getName(), true);
                this.messageHandler.sendPlayerBindSync(player);
                this.Logger.info(Language.getMessage(this.lang, "player-binded").replace("$player", player.getName()));
                boolean sendBindedMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-binded-message");
                if (sendBindedMessage) {
                    this.getProxy().broadcast(new ComponentBuilder(player.getName()).bold(true).append(new ComponentBuilder(Language.getMessage(this.lang, "player-binded").replace("$player", "")).color(ChatColor.DARK_GREEN).create()).create());
                }
                return true;
            }
            if (result == "Invalid Token!" && tries == 0) {
                this.Logger.info("Invalid Token detected, reconnecting...");
                this.isConnected = this.reconnect(true);
                return this.bind(playerKey, player, 1);
            }
        }
        this.messageHandler.sendPlayerBindSync(player);
        return false;
    }

    public Boolean bind(int playerKey, ProxiedPlayer player) {
        return this.bind(playerKey, player, 0);
    }

    @Override
    public Boolean bindFake(int playerKey, String name, int tries) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        if (this.playerBinds.containsKey(name) && this.playerBinds.get(name).booleanValue()) {
            return true;
        }
        String link = "http://" + this.host + ":" + this.port;
        String result = this.network.sendBindRequest(link, this.token, playerKey, String.format("%0", playerKey), name);
        this.playerBinds.put(name, false);
        if (result != null) {
            if (result == "SUCCESS") {
                this.playerBinds.put(name, true);
                this.Logger.info(Language.getMessage(this.lang, "player-binded").replace("$player", name));
                boolean sendBindedMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-binded-message");
                if (sendBindedMessage) {
                    this.getProxy().broadcast(new ComponentBuilder(name).bold(true).append(new ComponentBuilder(Language.getMessage(this.lang, "player-binded").replace("$player", "")).color(ChatColor.DARK_GREEN).create()).create());
                }
                return true;
            }
            if (result == "Invalid Token!" && tries == 0) {
                this.Logger.info("Invalid Token detected, reconnecting...");
                this.isConnected = this.reconnect(true);
                return this.bindFake(playerKey, name, 1);
            }
        }
        return false;
    }

    @Override
    public Boolean bindFake(int playerKey, String name) {
        return this.bindFake(playerKey, name, 0);
    }

    public Boolean disconnectPlayer(ProxiedPlayer player, int tries) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        String link = "http://" + this.host + ":" + this.port;
        String result = this.network.sendDisconnectRequest(link, this.token, player.getUniqueId().toString(), player.getName());
        if (result != null) {
            if (result == "SUCCESS") {
                this.playerBinds.remove(player.getName());
                this.messageHandler.sendPlayerBindSync(player);
                return true;
            }
            if (result == "Invalid Token!" && tries == 0) {
                this.Logger.info("Invalid Token detected, reconnecting...");
                this.isConnected = this.reconnect(true);
                return this.disconnectPlayer(player, 1);
            }
        }
        return false;
    }

    public Boolean disconnectPlayer(ProxiedPlayer player) {
        return this.disconnectPlayer(player, 0);
    }

    @Override
    public Boolean updateSettings(int proximityDistance, Boolean proximityToggle, Boolean voiceEffects) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        String link = "http://" + this.host + ":" + this.port;
        return this.network.sendUpdateSettingsRequest(link, this.token, proximityDistance, proximityToggle, voiceEffects);
    }

    @Override
    public void setNotConnected() {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return;
        }
        this.isConnected = false;
    }

    @Override
    public void reloadConfig() {
        this.saveResource("config.yml");
        File configFile = new File(this.getDataFolder(), "config.yml");
        try {
            config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveConfig() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(config, new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveResource(String resourcePath, boolean replace) {
        if (resourcePath == null || resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResourceAsStream(resourcePath = resourcePath.replace("\\", "/"));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found");
        }
        File outFile = new File(this.getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf("/");
        File outDir = new File(this.getDataFolder(), resourcePath.substring(0, lastIndex >= 0 ? lastIndex : 0));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException ex) {
            this.Logger.error("Could not save " + outFile.getName() + " to " + String.valueOf(outFile));
        }
    }

    @Override
    public void saveResource(String resourcePath) {
        this.saveResource(resourcePath, false);
    }

    public static Configuration getConfig() {
        return config;
    }

    public static GeyserVoice getInstance() {
        return instance;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public Map<String, Boolean> getPlayerBinds() {
        return this.playerBinds;
    }

    public String getToken() {
        return this.token;
    }

    public PluginMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public ScheduledTask getTaskRunner() {
        return this.taskRunner;
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

