/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.bungeecord.listeners;

import io.greitan.avion.bungeecord.GeyserVoice;
import io.greitan.avion.bungeecord.utils.Language;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class PlayerJoinHandler
implements Listener {
    private final GeyserVoice plugin;
    private final String lang;

    public PlayerJoinHandler(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    @EventHandler
    public void onPlayerJoin(PostLoginEvent event) {
        boolean isConnected = this.plugin.isConnected();
        ProxiedPlayer player = event.getPlayer();
        int playerBindKey = GeyserVoice.getConfig().getInt("config.players." + player.getName(), -1);
        if (isConnected && Objects.nonNull(playerBindKey) && playerBindKey != -1) {
            this.handleAutoBind(playerBindKey, player);
        }
        this.plugin.getMessageHandler().sendPlayerBindSync(player);
    }

    @EventHandler
    public void onPlayerConnect(ServerConnectedEvent event) {
        ProxiedPlayer player = event.getPlayer();
        this.plugin.getMessageHandler().sendPlayerBindSync(player);
    }

    private void handleAutoBind(int playerBindKey, ProxiedPlayer player) {
        player.sendMessage(new ComponentBuilder(Language.getMessage(this.lang, "plugin-autobind-enabled")).color(ChatColor.GREEN).append(new ComponentBuilder(" ").create()).append(new ComponentBuilder(Language.getMessage(this.lang, "plugin-autobind-binding")).color(ChatColor.YELLOW).create()).create());
        boolean isBound = this.plugin.bind(playerBindKey, player);
        if (!isBound) {
            player.sendMessage(new ComponentBuilder(Language.getMessage(this.lang, "plugin-autobind-failed")).color(ChatColor.RED).create());
        }
    }
}

