/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.bungeecord.listeners;

import io.greitan.avion.bungeecord.GeyserVoice;
import io.greitan.avion.bungeecord.utils.Language;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class PlayerQuitHandler
implements Listener {
    private final GeyserVoice plugin;
    private final String lang;

    public PlayerQuitHandler(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    @EventHandler
    public void onPlayerQuit(PlayerDisconnectEvent event) {
        ProxiedPlayer player = event.getPlayer();
        boolean isBound = this.plugin.getPlayerBinds().getOrDefault(player.getName(), false);
        if (this.plugin.isConnected() && isBound) {
            this.handlePlayerDisconnect(player);
        }
    }

    private void handlePlayerDisconnect(ProxiedPlayer player) {
        boolean isDisconnected = this.plugin.disconnectPlayer(player);
        this.plugin.playerDataList.remove(player.getUniqueId().toString());
        String playerName = player.getName();
        String disconnectMessage = Language.getMessage(this.lang, "player-disconnect-success").replace("$player", playerName);
        if (isDisconnected) {
            this.plugin.Logger.info(disconnectMessage);
            boolean sendDisconnectMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-disconnect-message");
            if (sendDisconnectMessage) {
                this.plugin.getProxy().broadcast(new ComponentBuilder(disconnectMessage).color(ChatColor.YELLOW).create());
            }
        } else {
            this.plugin.Logger.error(Language.getMessage(this.lang, "player-disconnect-failed").replace("$player", playerName));
            this.plugin.getPlayerBinds().remove(playerName);
        }
    }
}

