/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.bungeecord.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.greitan.avion.bungeecord.GeyserVoice;
import io.greitan.avion.common.network.Payloads;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class PluginMessageHandler
implements Listener {
    private final GeyserVoice plugin;
    public static final String channelName = "geyservoice:main";

    public PluginMessageHandler(GeyserVoice plugin) {
        this.plugin = plugin;
    }

    public void sendPlayerBindSync(ProxiedPlayer player) {
        boolean isBound = this.plugin.isConnected() && this.plugin.getPlayerBinds().getOrDefault(player.getName(), false) != false;
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("PlayerBindSync");
        out.writeUTF(player.getName());
        out.writeBoolean(isBound);
        for (ServerInfo server : this.plugin.getProxy().getServers().values()) {
            server.sendData(channelName, out.toByteArray(), true);
        }
        this.plugin.Logger.info("Send PariticipantJoined message");
    }

    @EventHandler
    public void onPluginMessageReceived(PluginMessageEvent event) {
        if (!event.getTag().equals(channelName)) {
            return;
        }
        String serverName = "";
        if (event.getSender() instanceof Server) {
            Server backend = (Server)event.getSender();
            serverName = backend.getInfo().getName();
        } else if (event.getSender() instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)event.getSender();
            serverName = player.getServer().getInfo().getName();
        } else {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
        String subchannel = in.readUTF();
        if (subchannel.equals("PlayerDataList")) {
            String rawPlayerDataList = in.readUTF();
            this.plugin.Logger.debug("Received playerdatalist: " + rawPlayerDataList);
            try {
                List<Payloads.PlayerData> playerDataList = Arrays.asList(GeyserVoice.objectMapper.readValue(rawPlayerDataList, Payloads.PlayerData[].class));
                for (Payloads.PlayerData playerData : playerDataList) {
                    playerData.DimensionId = serverName + "_" + playerData.DimensionId;
                    this.plugin.playerDataList.put(playerData.PlayerId, playerData);
                }
            }
            catch (JsonProcessingException jsonProcessingException) {}
        } else if (subchannel.equals("PlayerData")) {
            Payloads.PlayerData playerData = new Payloads.PlayerData();
            playerData.PlayerId = in.readUTF();
            playerData.DimensionId = in.readUTF();
            playerData.Location.x = in.readDouble();
            playerData.Location.y = in.readDouble();
            playerData.Location.z = in.readDouble();
            playerData.Rotation = in.readDouble();
            playerData.EchoFactor = in.readDouble();
            playerData.Muffled = in.readBoolean();
            playerData.IsDead = in.readBoolean();
            playerData.DimensionId = serverName + "_" + playerData.DimensionId;
            this.plugin.playerDataList.put(playerData.PlayerId, playerData);
        }
        event.setCancelled(true);
    }
}

