/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.bungeecord.tasks;

import io.greitan.avion.bungeecord.GeyserVoice;
import io.greitan.avion.bungeecord.utils.Language;
import io.greitan.avion.common.network.Payloads;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ComponentBuilder;

public class PositionsTask
implements Runnable {
    private final GeyserVoice plugin;
    private final String lang;
    private boolean isConnected = false;
    private Integer ReconnectRetries = 0;

    public PositionsTask(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    @Override
    public void run() {
        this.isConnected = this.plugin.isConnected();
        String host = this.plugin.getHost();
        int port = this.plugin.getPort();
        String token = this.plugin.getToken();
        String link = "http://" + host + ":" + port;
        if (this.isConnected && host != null && token != null) {
            Payloads.UpdatePacket updatePacket = new Payloads.UpdatePacket();
            updatePacket.Token = token;
            updatePacket.Players = this.getPlayerDataList(this.plugin.playerDataList);
            Payloads.MCCommPacket response = this.plugin.network.sendPostRequest(link, updatePacket);
            if (response != null) {
                if (response.PacketId == Payloads.PacketType.AckUpdate.ordinal()) {
                    return;
                }
                if (response.PacketId == Payloads.PacketType.Deny.ordinal()) {
                    Payloads.DenyPacket packetData = GeyserVoice.objectMapper.convertValue((Object)response, Payloads.DenyPacket.class);
                    this.plugin.Logger.error(packetData.Reason);
                    if (!packetData.Reason.equals("Invalid Token!")) {
                        this.plugin.setNotConnected();
                        this.cancel();
                        return;
                    }
                } else {
                    return;
                }
            }
            if (!this.isConnected) {
                return;
            }
            this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-lost"));
            this.plugin.setNotConnected();
            if (GeyserVoice.getConfig().getBoolean("config.auto-reconnect")) {
                if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                    this.plugin.getProxy().broadcast(new ComponentBuilder(Language.getMessage(this.lang, "plugin-connection-lost-reconnect")).color(ChatColor.RED).create());
                }
                this.ReconnectRetries = 0;
                this.Reconnect();
                return;
            }
            if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                this.plugin.getProxy().broadcast(new ComponentBuilder(Language.getMessage(this.lang, "plugin-connection-lost")).color(ChatColor.RED).create());
            }
            this.cancel();
        }
    }

    public List<Payloads.PlayerData> getPlayerDataList(Map<String, Payloads.PlayerData> allPlayerDataList) {
        ArrayList<Payloads.PlayerData> playerDataList = new ArrayList<Payloads.PlayerData>();
        for (String playerId : allPlayerDataList.keySet()) {
            playerDataList.add(allPlayerDataList.get(playerId));
        }
        return playerDataList;
    }

    private Boolean Reconnect() {
        if (this.ReconnectRetries < 5) {
            Integer n = this.ReconnectRetries;
            this.ReconnectRetries = this.ReconnectRetries + 1;
            this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-attempt").replace("$attempt", this.ReconnectRetries.toString()));
            if (this.plugin.reconnect(true).booleanValue()) {
                this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-success"));
                if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                    this.plugin.getProxy().broadcast(new ComponentBuilder(Language.getMessage(this.lang, "plugin-connection-reconnecting-success")).color(ChatColor.GREEN).create());
                }
                return true;
            }
            if (this.ReconnectRetries < 5) {
                this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-failed-retry"));
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.Reconnect();
            }
            this.plugin.Logger.error(Language.getMessage(this.lang, "plugin-connection-reconnecting-failed"));
            if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                this.plugin.getProxy().broadcast(new ComponentBuilder(Language.getMessage(this.lang, "plugin-connection-reconnecting-failed")).color(ChatColor.RED).create());
            }
            this.cancel();
        }
        return false;
    }

    private void cancel() {
        this.plugin.getTaskRunner().cancel();
    }
}

