/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.common.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.greitan.avion.common.network.Payloads;
import io.greitan.avion.common.utils.BaseLogger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

public class Network {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private BaseLogger Logger;
    private static String Version = "1.0.0";

    public <T extends BaseLogger> Network(T logger) {
        this.Logger = logger;
    }

    public Payloads.MCCommPacket sendPostRequest(String url, Payloads.MCCommPacket data) {
        try {
            String jsonData = objectMapper.writeValueAsString(data);
            this.Logger.debug("Request: " + jsonData.toString());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            String body = response.body();
            this.Logger.debug("Response: " + body);
            if (statusCode == 200) {
                return objectMapper.readValue(body, Payloads.MCCommPacket.class);
            }
            this.Logger.error("Sending HTTP Packet Failed, Reason: HTTP_EXCEPTION, STATUS_CODE: " + statusCode);
            return null;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.Logger.error("Can't connect to voice chat server! " + message);
            return null;
        }
    }

    public String sendLoginRequest(String link, String serverKey) {
        Payloads.LoginPacket loginPacket = new Payloads.LoginPacket();
        loginPacket.LoginKey = serverKey;
        loginPacket.Version = Version;
        Payloads.MCCommPacket response = this.sendPostRequest(link, loginPacket);
        if (response != null) {
            if (response.PacketId == Payloads.PacketType.Accept.ordinal()) {
                Payloads.AcceptPacket packetData = objectMapper.convertValue((Object)response, Payloads.AcceptPacket.class);
                return packetData.Token;
            }
            if (response.PacketId == Payloads.PacketType.Deny.ordinal() || response instanceof Payloads.DenyPacket) {
                Payloads.DenyPacket packetData = objectMapper.convertValue((Object)response, Payloads.DenyPacket.class);
                this.Logger.error("Login Denied. Server denied link request! Reason: " + packetData.Reason);
            }
        } else {
            this.Logger.error("Could not contact server. Please check if your IPAddress and Port are correct!");
        }
        return null;
    }

    public void sendLogoutRequest(String link, String token) {
        Payloads.LogoutPacket logoutPacket = new Payloads.LogoutPacket();
        logoutPacket.Token = token;
        this.sendPostRequest(link, logoutPacket);
    }

    public String sendBindRequest(String link, String token, Integer playerKey, String playerId, String playerName) {
        Payloads.BindPacket bindPacket = new Payloads.BindPacket();
        bindPacket.PlayerId = playerId;
        bindPacket.PlayerKey = playerKey;
        bindPacket.Gamertag = playerName;
        bindPacket.Token = token;
        Payloads.MCCommPacket bindStatus = this.sendPostRequest(link, bindPacket);
        if (bindStatus == null) {
            return null;
        }
        if (bindStatus.PacketId == Payloads.PacketType.Accept.ordinal()) {
            return "SUCCESS";
        }
        if (bindStatus instanceof Payloads.DenyPacket) {
            Payloads.DenyPacket packetData = objectMapper.convertValue((Object)bindStatus, Payloads.DenyPacket.class);
            this.Logger.error("Binding " + bindPacket.Gamertag + " to " + playerKey + " failed. Reason: " + packetData.Reason);
            return packetData.Reason;
        }
        return null;
    }

    public String sendDisconnectRequest(String link, String token, String playerId, String playerName) {
        Payloads.DisconnectParticipantPacket disconnectParticipantPacket = new Payloads.DisconnectParticipantPacket();
        disconnectParticipantPacket.Token = token;
        disconnectParticipantPacket.PlayerId = playerId;
        Payloads.MCCommPacket disconnectStatus = this.sendPostRequest(link, disconnectParticipantPacket);
        if (disconnectStatus == null) {
            return null;
        }
        if (disconnectStatus.PacketId == Payloads.PacketType.Accept.ordinal()) {
            return "SUCCESS";
        }
        if (disconnectStatus instanceof Payloads.DenyPacket) {
            Payloads.DenyPacket packetData = objectMapper.convertValue((Object)disconnectStatus, Payloads.DenyPacket.class);
            this.Logger.error("Disconnecting player " + playerName + " failed. Reason: " + packetData.Reason);
            return packetData.Reason;
        }
        return null;
    }

    public Boolean sendUpdateSettingsRequest(String link, String token, int proximityDistance, Boolean proximityToggle, Boolean voiceEffects) {
        Payloads.SetDefaultSettingsPacket setDefaultSettingsPacket = new Payloads.SetDefaultSettingsPacket();
        setDefaultSettingsPacket.ProximityDistance = proximityDistance;
        setDefaultSettingsPacket.ProximityToggle = proximityToggle;
        setDefaultSettingsPacket.VoiceEffects = voiceEffects;
        setDefaultSettingsPacket.Token = token;
        return this.sendPostRequest(link, setDefaultSettingsPacket) != null;
    }
}

