/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.paper.listeners;

import io.greitan.avion.paper.GeyserVoice;
import io.greitan.avion.paper.utils.Language;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinHandler
implements Listener {
    private final GeyserVoice plugin;
    private final String lang;

    public PlayerJoinHandler(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        boolean isConnected = this.plugin.isConnected();
        Player player = event.getPlayer();
        int playerBindKey = this.plugin.getConfig().getInt("config.players." + player.getName(), -1);
        if (!this.plugin.usesProxy && isConnected && Objects.nonNull(playerBindKey) && playerBindKey != -1) {
            this.handleAutoBind(playerBindKey, player);
        }
    }

    private void handleAutoBind(int playerBindKey, Player player) {
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)Language.getMessage(this.lang, "plugin-autobind-enabled")).color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)" "))).append(Component.text((String)Language.getMessage(this.lang, "plugin-autobind-binding")).color((TextColor)NamedTextColor.YELLOW)));
        boolean isBound = this.plugin.bind(playerBindKey, player);
        if (!isBound) {
            player.sendMessage(Component.text((String)Language.getMessage(this.lang, "plugin-autobind-failed")).color((TextColor)NamedTextColor.RED));
        }
    }
}

