/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.paper.listeners;

import io.greitan.avion.paper.GeyserVoice;
import io.greitan.avion.paper.utils.Language;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerQuitHandler
implements Listener {
    private final GeyserVoice plugin;
    private final String lang;

    public PlayerQuitHandler(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        boolean isBound = this.plugin.getPlayerBinds().getOrDefault(player.getName(), false);
        if (isBound) {
            if (!this.plugin.usesProxy && this.plugin.isConnected()) {
                this.handlePlayerDisconnect(player);
            } else if (this.plugin.usesProxy) {
                this.plugin.getPlayerBinds().remove(player.getName());
            }
        }
    }

    private void handlePlayerDisconnect(Player player) {
        boolean isDisconnected = this.plugin.disconnectPlayer(player);
        String playerName = player.getName();
        String disconnectMessage = Language.getMessage(this.lang, "player-disconnect-success").replace("$player", playerName);
        if (isDisconnected) {
            this.plugin.Logger.info(disconnectMessage);
            boolean sendDisconnectMessage = this.plugin.getConfig().getBoolean("config.voice.send-disconnect-message");
            if (sendDisconnectMessage) {
                Bukkit.broadcast((Component)Component.text((String)disconnectMessage).color((TextColor)NamedTextColor.YELLOW));
            }
        } else {
            this.plugin.Logger.error(Language.getMessage(this.lang, "player-disconnect-failed").replace("$player", playerName));
            this.plugin.getPlayerBinds().remove(playerName);
        }
    }
}

