/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.paper.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.greitan.avion.common.network.Payloads;
import io.greitan.avion.paper.GeyserVoice;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class PluginMessageHandler
implements PluginMessageListener {
    private final GeyserVoice plugin;
    public static final String channelName = "geyservoice:main";

    public PluginMessageHandler(GeyserVoice plugin) {
        this.plugin = plugin;
    }

    public void sendPlayerData(Player player, Payloads.PlayerData playerData) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("PlayerData");
        out.writeUTF(playerData.PlayerId);
        out.writeUTF(playerData.DimensionId);
        out.writeDouble(playerData.Location.x);
        out.writeDouble(playerData.Location.y);
        out.writeDouble(playerData.Location.z);
        out.writeDouble(playerData.Rotation);
        out.writeDouble(playerData.EchoFactor);
        out.writeBoolean(playerData.Muffled);
        out.writeBoolean(playerData.IsDead);
        player.sendPluginMessage((Plugin)this.plugin, channelName, out.toByteArray());
    }

    public void sendPlayerDataList(Server server, List<Payloads.PlayerData> playerDataList) {
        try {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("PlayerDataList");
            out.writeUTF(GeyserVoice.objectMapper.writeValueAsString(playerDataList));
            server.sendPluginMessage((Plugin)this.plugin, channelName, out.toByteArray());
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals(channelName)) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subchannel = in.readUTF();
        if (subchannel.equals("PlayerBindSync")) {
            String username = in.readUTF();
            boolean isBound = in.readBoolean();
            if (this.plugin.getPlayerBinds().getOrDefault(username, false) != isBound) {
                if (isBound) {
                    this.plugin.Logger.info(username + " has joined the voicechat!");
                } else {
                    this.plugin.Logger.info(username + " has left the voicechat!");
                }
                this.plugin.getPlayerBinds().put(username, isBound);
            }
        }
    }
}

