/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.paper.tasks;

import io.greitan.avion.common.network.Payloads;
import io.greitan.avion.paper.GeyserVoice;
import io.greitan.avion.paper.utils.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class PositionsTask
extends BukkitRunnable {
    private final GeyserVoice plugin;
    private final String lang;
    private boolean isConnected = false;
    private Integer ReconnectRetries = 0;

    public PositionsTask(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    public void run() {
        if (this.plugin.usesProxy) {
            this.isConnected = true;
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.plugin.getMessageHandler().sendPlayerData(player, this.getPlayerData(player));
            }
            return;
        }
        this.isConnected = this.plugin.isConnected();
        String host = this.plugin.getHost();
        int port = this.plugin.getPort();
        String token = this.plugin.getToken();
        String link = "http://" + host + ":" + port;
        if (this.isConnected && host != null && token != null) {
            Payloads.UpdatePacket updatePacket = new Payloads.UpdatePacket();
            updatePacket.Token = token;
            updatePacket.Players = this.getPlayerDataList();
            Payloads.MCCommPacket response = this.plugin.network.sendPostRequest(link, updatePacket);
            if (response != null) {
                if (response.PacketId == Payloads.PacketType.AckUpdate.ordinal()) {
                    return;
                }
                if (response.PacketId == Payloads.PacketType.Deny.ordinal()) {
                    Payloads.DenyPacket packetData = GeyserVoice.objectMapper.convertValue((Object)response, Payloads.DenyPacket.class);
                    this.plugin.Logger.error(packetData.Reason);
                    if (!packetData.Reason.equals("Invalid Token!")) {
                        this.plugin.setNotConnected();
                        this.cancel();
                        return;
                    }
                } else {
                    return;
                }
            }
            if (!this.isConnected) {
                return;
            }
            this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-lost"));
            this.plugin.setNotConnected();
            if (this.plugin.getConfig().getBoolean("config.auto-reconnect")) {
                if (this.plugin.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                    Bukkit.broadcast((Component)Component.text((String)Language.getMessage(this.lang, "plugin-connection-lost-reconnect")).color((TextColor)NamedTextColor.RED));
                }
                this.ReconnectRetries = 0;
                this.Reconnect();
                return;
            }
            if (this.plugin.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                Bukkit.broadcast((Component)Component.text((String)Language.getMessage(this.lang, "plugin-connection-lost")).color((TextColor)NamedTextColor.RED));
            }
            this.cancel();
        }
    }

    public List<Payloads.PlayerData> getPlayerDataList() {
        ArrayList<Payloads.PlayerData> playerDataList = new ArrayList<Payloads.PlayerData>();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            Payloads.PlayerData playerData = this.getPlayerData(player);
            playerDataList.add(playerData);
        }
        return playerDataList;
    }

    public Payloads.PlayerData getPlayerData(Player player) {
        Location headLocation = player.getEyeLocation();
        Payloads.LocationData locationData = new Payloads.LocationData();
        locationData.x = headLocation.getX();
        locationData.y = headLocation.getY();
        locationData.z = headLocation.getZ();
        Payloads.PlayerData playerData = new Payloads.PlayerData();
        playerData.PlayerId = player.getUniqueId().toString();
        playerData.DimensionId = this.getDimensionId(player);
        playerData.Location = locationData;
        playerData.Rotation = player.getLocation().getYaw();
        playerData.EchoFactor = player.getWorld().getEnvironment() == World.Environment.NORMAL ? this.getCaveDensity(player) : 0.0;
        playerData.Muffled = player.isInWater();
        playerData.IsDead = player.isDead();
        return playerData;
    }

    public double getCaveDensity(Player player) {
        if (!this.isConnected) {
            return 0.0;
        }
        String[] caveBlocks = new String[]{"STONE", "DIORITE", "GRANITE", "DEEPSLATE", "TUFF"};
        int blockCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Vector direction = new Vector(x, y, z);
                    blockCount += this.castRayUntilBlock(new BlockIterator(player.getWorld(), player.getLocation().toVector(), direction, 0.0, 50), caveBlocks);
                }
            }
        }
        return (double)blockCount / 26.0;
    }

    private int castRayUntilBlock(BlockIterator blockIterator, String[] caveBlocks) {
        while (blockIterator.hasNext()) {
            Block block = blockIterator.next();
            if (!block.getType().isSolid()) continue;
            if (!Arrays.asList(caveBlocks).contains(this.getBlockType(block))) break;
            return 1;
        }
        return 0;
    }

    private String getBlockType(Block block) {
        return block.getType().toString();
    }

    private String getDimensionId(Player player) {
        String worldName;
        return switch (worldName = player.getWorld().getName()) {
            case "world" -> "minecraft:overworld";
            case "world_nether" -> "minecraft:nether";
            case "world_the_end" -> "minecraft:the_end";
            default -> "minecraft:unknown";
        };
    }

    private Boolean Reconnect() {
        if (this.ReconnectRetries < 5) {
            Integer n = this.ReconnectRetries;
            this.ReconnectRetries = this.ReconnectRetries + 1;
            this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-attempt").replace("$attempt", this.ReconnectRetries.toString()));
            if (this.plugin.reconnect(true).booleanValue()) {
                this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-success"));
                if (this.plugin.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                    Bukkit.broadcast((Component)Component.text((String)Language.getMessage(this.lang, "plugin-connection-reconnecting-success")).color((TextColor)NamedTextColor.GREEN));
                }
                return true;
            }
            if (this.ReconnectRetries < 5) {
                this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-failed-retry"));
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.Reconnect();
            }
            this.plugin.Logger.error(Language.getMessage(this.lang, "plugin-connection-reconnecting-failed"));
            if (this.plugin.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                Bukkit.broadcast((Component)Component.text((String)Language.getMessage(this.lang, "plugin-connection-reconnecting-failed")).color((TextColor)NamedTextColor.RED));
            }
            this.cancel();
        }
        return false;
    }
}

