/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.velocity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.TaskStatus;
import de.leonhard.storage.Yaml;
import io.greitan.avion.common.BaseGeyserVoice;
import io.greitan.avion.common.network.Network;
import io.greitan.avion.common.network.Payloads;
import io.greitan.avion.velocity.commands.VoiceCommand;
import io.greitan.avion.velocity.listeners.PlayerJoinHandler;
import io.greitan.avion.velocity.listeners.PlayerQuitHandler;
import io.greitan.avion.velocity.listeners.PluginMessageHandler;
import io.greitan.avion.velocity.tasks.PositionsTask;
import io.greitan.avion.velocity.utils.Language;
import io.greitan.avion.velocity.utils.VelocityLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

@Plugin(id="geyservoice", name="GeyserVoice", version="v1.4.0.4-beta", description="Plugin that adds support for using VoiceCraft on Java servers.", authors={"Alpha"}, url="https://uninode.de")
public class GeyserVoice
implements BaseGeyserVoice {
    private final ProxyServer proxy;
    private final File dataFolder;
    private static Yaml config;
    private static GeyserVoice instance;
    private boolean isConnected = false;
    private String host = "";
    private int port = 0;
    private String serverKey = "";
    private Map<String, Boolean> playerBinds = new HashMap<String, Boolean>();
    private String token = "";
    private String lang;
    private PluginMessageHandler messageHandler = new PluginMessageHandler(this);
    public Map<String, Payloads.PlayerData> playerDataList = new HashMap<String, Payloads.PlayerData>();
    private ScheduledTask taskRunner;
    private PositionsTask positionsTask = new PositionsTask(this, this.lang);
    public VelocityLogger Logger = new VelocityLogger();
    public Network network = new Network(this.Logger);
    public static final ObjectMapper objectMapper;

    @Inject
    public GeyserVoice(ProxyServer proxy, @DataDirectory Path dataDirectory) {
        instance = this;
        this.proxy = proxy;
        this.dataFolder = dataDirectory.toFile();
        this.saveResource("/config.yml");
        config = new Yaml("config", this.dataFolder.toString());
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.Logger.info("Enabling GeyserVoice");
        this.lang = GeyserVoice.getConfig().getString("config.lang");
        int positionTaskInterval = GeyserVoice.getConfig().getOrDefault("config.voice.position-task-interval", 1);
        Language.init(this);
        this.proxy.getEventManager().register((Object)this, (Object)this.messageHandler);
        this.proxy.getChannelRegistrar().register(new ChannelIdentifier[]{PluginMessageHandler.channelName});
        CommandManager commandManager = this.proxy.getCommandManager();
        CommandMeta commandMeta = commandManager.metaBuilder("voice").aliases(new String[]{"voicecraft"}).plugin((Object)this).build();
        VoiceCommand voiceCommand = new VoiceCommand(this, this.lang);
        commandManager.register(commandMeta, (Command)voiceCommand);
        this.taskRunner = this.proxy.getScheduler().buildTask((Object)this, () -> {
            if (!this.positionsTask.run().booleanValue()) {
                this.taskRunner.cancel();
            }
        }).repeat((long)(positionTaskInterval * 50), TimeUnit.MILLISECONDS).schedule();
        this.proxy.getEventManager().register((Object)this, (Object)new PlayerJoinHandler(this, this.lang));
        this.proxy.getEventManager().register((Object)this, (Object)new PlayerQuitHandler(this, this.lang));
        this.reload();
    }

    @Override
    public void reload() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.Logger.info(Language.getMessage(this.lang, "plugin-config-loaded"));
        this.Logger.info(Language.getMessage(this.lang, "plugin-command-executor"));
        this.host = GeyserVoice.getConfig().getString("config.host");
        this.port = GeyserVoice.getConfig().getInt("config.port");
        this.serverKey = GeyserVoice.getConfig().getString("config.server-key");
        if (GeyserVoice.getConfig().getBoolean("config.auto-reconnect")) {
            this.isConnected = this.reconnect(true);
        }
        int positionTaskInterval = GeyserVoice.getConfig().getOrDefault("config.voice.position-task-interval", 1);
        if (this.taskRunner.status() != TaskStatus.CANCELLED) {
            this.taskRunner.cancel();
        }
        this.taskRunner = this.proxy.getScheduler().buildTask((Object)this, () -> {
            if (!this.positionsTask.run().booleanValue()) {
                this.taskRunner.cancel();
            }
        }).repeat((long)(positionTaskInterval * 50), TimeUnit.MILLISECONDS).schedule();
        int proximityDistance = GeyserVoice.getConfig().getInt("config.voice.proximity-distance");
        Boolean proximityToggle = GeyserVoice.getConfig().getBoolean("config.voice.proximity-toggle");
        Boolean voiceEffects = GeyserVoice.getConfig().getBoolean("config.voice.voice-effects");
        this.updateSettings(proximityDistance, proximityToggle, voiceEffects);
    }

    @Override
    public Boolean connect(String host, int port, String serverKey) {
        if (Objects.nonNull(host) && Objects.nonNull(serverKey)) {
            GeyserVoice.getConfig().set("config.host", host);
            GeyserVoice.getConfig().set("config.port", port);
            GeyserVoice.getConfig().set("config.server-key", serverKey);
            this.saveConfig();
            this.reloadConfig();
            this.reload();
            return this.isConnected;
        }
        this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-invalid-data"));
        return false;
    }

    @Override
    public Boolean reconnect(Boolean force) {
        if (this.isConnected && !force.booleanValue()) {
            return true;
        }
        if (this.isConnected) {
            this.disconnect("Reconnecting to another server.");
        }
        if (Objects.nonNull(this.host) && Objects.nonNull(this.serverKey)) {
            String link = "http://" + this.host + ":" + this.port;
            String Token2 = this.network.sendLoginRequest(link, this.serverKey);
            if (Objects.nonNull(Token2)) {
                this.Logger.info(Language.getMessage(this.lang, "plugin-connect-connected"));
                this.isConnected = true;
                this.token = Token2;
            } else {
                this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-failed"));
            }
            return this.isConnected;
        }
        this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-invalid-data"));
        return false;
    }

    @Override
    public void disconnect(String reason) {
        if (!this.isConnected) {
            return;
        }
        if (Objects.nonNull(this.host) && Objects.nonNull(this.serverKey)) {
            String link = "http://" + this.host + ":" + this.port;
            this.network.sendLogoutRequest(link, this.token);
            this.isConnected = false;
            String disconnectMessage = Language.getMessage(this.lang, "plugin-connection-disconnect").replace("$reason", reason);
            this.Logger.info(disconnectMessage);
            boolean sendVoipDisconnectMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-voip-disconnect-message");
            if (sendVoipDisconnectMessage) {
                this.getProxy().sendMessage(Component.text((String)disconnectMessage).color((TextColor)NamedTextColor.YELLOW));
            }
        } else {
            this.Logger.warn(Language.getMessage(this.lang, "plugin-connect-invalid-data"));
        }
    }

    @Override
    public void disconnect() {
        this.disconnect("N.A.");
    }

    public Boolean bind(int playerKey, Player player, int tries) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        if (this.playerBinds.containsKey(player.getUsername()) && this.playerBinds.get(player.getUsername()).booleanValue()) {
            return true;
        }
        String link = "http://" + this.host + ":" + this.port;
        GeyserVoice.getConfig().set("config.players." + player.getUsername(), playerKey);
        this.saveConfig();
        String result = this.network.sendBindRequest(link, this.token, playerKey, player.getUniqueId().toString(), player.getUsername());
        this.playerBinds.put(player.getUsername(), false);
        if (result != null) {
            if (result == "SUCCESS") {
                this.playerBinds.put(player.getUsername(), true);
                this.messageHandler.sendPlayerBindSync(player);
                this.Logger.info(Language.getMessage(this.lang, "player-binded").replace("$player", player.getUsername()));
                boolean sendBindedMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-binded-message");
                if (sendBindedMessage) {
                    this.getProxy().sendMessage(((TextComponent)Component.text((String)player.getUsername()).decorate(TextDecoration.BOLD)).append(Component.text((String)Language.getMessage(this.lang, "player-binded").replace("$player", "")).color((TextColor)NamedTextColor.DARK_GREEN)));
                }
                return true;
            }
            if (result == "Invalid Token!" && tries == 0) {
                this.Logger.info("Invalid Token detected, reconnecting...");
                this.isConnected = this.reconnect(true);
                return this.bind(playerKey, player, 1);
            }
        }
        this.messageHandler.sendPlayerBindSync(player);
        return false;
    }

    public Boolean bind(int playerKey, Player player) {
        return this.bind(playerKey, player, 0);
    }

    @Override
    public Boolean bindFake(int playerKey, String name, int tries) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        if (this.playerBinds.containsKey(name) && this.playerBinds.get(name).booleanValue()) {
            return true;
        }
        String link = "http://" + this.host + ":" + this.port;
        String result = this.network.sendBindRequest(link, this.token, playerKey, String.format("%0", playerKey), name);
        this.playerBinds.put(name, false);
        if (result != null) {
            if (result == "SUCCESS") {
                this.playerBinds.put(name, true);
                this.Logger.info(Language.getMessage(this.lang, "player-binded").replace("$player", name));
                boolean sendBindedMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-binded-message");
                if (sendBindedMessage) {
                    this.getProxy().sendMessage(((TextComponent)Component.text((String)name).decorate(TextDecoration.BOLD)).append(Component.text((String)Language.getMessage(this.lang, "player-binded").replace("$player", "")).color((TextColor)NamedTextColor.DARK_GREEN)));
                }
                return true;
            }
            if (result == "Invalid Token!" && tries == 0) {
                this.Logger.info("Invalid Token detected, reconnecting...");
                this.isConnected = this.reconnect(true);
                return this.bindFake(playerKey, name, 1);
            }
        }
        return false;
    }

    @Override
    public Boolean bindFake(int playerKey, String name) {
        return this.bindFake(playerKey, name, 0);
    }

    public Boolean disconnectPlayer(Player player, int tries) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        String link = "http://" + this.host + ":" + this.port;
        String result = this.network.sendDisconnectRequest(link, this.token, player.getUniqueId().toString(), player.getUsername());
        if (result != null) {
            if (result == "SUCCESS") {
                this.playerBinds.remove(player.getUsername());
                this.messageHandler.sendPlayerBindSync(player);
                return true;
            }
            if (result == "Invalid Token!" && tries == 0) {
                this.Logger.info("Invalid Token detected, reconnecting...");
                this.isConnected = this.reconnect(true);
                return this.disconnectPlayer(player, 1);
            }
        }
        return false;
    }

    public Boolean disconnectPlayer(Player player) {
        return this.disconnectPlayer(player, 0);
    }

    @Override
    public Boolean updateSettings(int proximityDistance, Boolean proximityToggle, Boolean voiceEffects) {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return false;
        }
        String link = "http://" + this.host + ":" + this.port;
        return this.network.sendUpdateSettingsRequest(link, this.token, proximityDistance, proximityToggle, voiceEffects);
    }

    @Override
    public void setNotConnected() {
        if (!this.isConnected || Objects.isNull(this.host) || Objects.isNull(this.serverKey)) {
            return;
        }
        this.isConnected = false;
    }

    @Override
    public void reloadConfig() {
        config.forceReload();
    }

    @Override
    public void saveConfig() {
        config.write();
    }

    public void saveDefaultConfig() {
        config.addDefaultsFromInputStream(this.getClass().getResourceAsStream("/config.yaml"));
    }

    public void saveResource(String resourcePath, boolean replace) {
        if (resourcePath == null || resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        resourcePath = resourcePath.replace("\\", "/");
        InputStream in = this.getClass().getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found");
        }
        File outFile = new File(this.getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf("/");
        File outDir = new File(this.dataFolder, resourcePath.substring(0, lastIndex >= 0 ? lastIndex : 0));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException ex) {
            this.Logger.error("Could not save " + outFile.getName() + " to " + String.valueOf(outFile));
        }
    }

    @Override
    public void saveResource(String resourcePath) {
        this.saveResource(resourcePath, false);
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public static Yaml getConfig() {
        return config;
    }

    public static GeyserVoice getInstance() {
        return instance;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public Map<String, Boolean> getPlayerBinds() {
        return this.playerBinds;
    }

    public String getToken() {
        return this.token;
    }

    public PluginMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

