/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import io.greitan.avion.common.commands.BaseVoiceCommand;
import io.greitan.avion.common.utils.DoubleStringOperation;
import io.greitan.avion.common.utils.EmptyOperation;
import io.greitan.avion.common.utils.IntegerOperation;
import io.greitan.avion.common.utils.StringOperation;
import io.greitan.avion.velocity.GeyserVoice;
import io.greitan.avion.velocity.utils.Language;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class VoiceCommand
implements SimpleCommand {
    private final BaseVoiceCommand voiceCommand;
    private final GeyserVoice plugin;
    private final String lang;

    public VoiceCommand(GeyserVoice plugin, String lang) {
        this.voiceCommand = new BaseVoiceCommand(plugin);
        this.plugin = plugin;
        this.lang = lang;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        final CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        this.voiceCommand.onCommand(args, this.plugin.isConnected(), sender instanceof Player, new StringOperation(){

            @Override
            public boolean execute(String permission) {
                if (sender instanceof Player) {
                    return sender.hasPermission(permission);
                }
                return true;
            }
        }, new DoubleStringOperation(){

            @Override
            public void execute(String text, String rawColor) {
                NamedTextColor color = NamedTextColor.RED;
                if (rawColor == "red") {
                    color = NamedTextColor.RED;
                } else if (rawColor == "aqua") {
                    color = NamedTextColor.AQUA;
                } else if (rawColor == "green") {
                    color = NamedTextColor.GREEN;
                } else if (rawColor == "yellow") {
                    color = NamedTextColor.YELLOW;
                }
                TextComponent message = (TextComponent)Component.text((String)Language.getMessage(VoiceCommand.this.lang, text)).color((TextColor)color);
                if (sender instanceof Player) {
                    sender.sendMessage((Component)message);
                } else {
                    VoiceCommand.this.plugin.Logger.log((Component)message);
                }
            }
        }, new IntegerOperation(){

            @Override
            public boolean execute(int key) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    return VoiceCommand.this.plugin.bind(key, player);
                }
                return false;
            }
        }, new EmptyOperation(){

            @Override
            public boolean execute() {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    GeyserVoice.getConfig().set("config.players." + player.getUsername(), null);
                    return true;
                }
                return false;
            }
        });
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("voice.cmd");
    }

    public List<String> suggest(final SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        return this.voiceCommand.onTabComplete(args, new StringOperation(){

            @Override
            public boolean execute(String permission) {
                return invocation.source().hasPermission(permission);
            }
        });
    }
}

