/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.velocity.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.Player;
import io.greitan.avion.velocity.GeyserVoice;
import io.greitan.avion.velocity.utils.Language;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class PlayerJoinHandler {
    private final GeyserVoice plugin;
    private final String lang;

    public PlayerJoinHandler(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    @Subscribe
    public void onPlayerJoin(PostLoginEvent event) {
        boolean isConnected = this.plugin.isConnected();
        Player player = event.getPlayer();
        int playerBindKey = GeyserVoice.getConfig().getOrDefault("config.players." + player.getUsername(), -1);
        if (isConnected && Objects.nonNull(playerBindKey) && playerBindKey != -1) {
            this.handleAutoBind(playerBindKey, player);
        }
    }

    @Subscribe
    public void onPlayerConnect(ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        this.plugin.getMessageHandler().sendPlayerBindSync(player);
    }

    private void handleAutoBind(int playerBindKey, Player player) {
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)Language.getMessage(this.lang, "plugin-autobind-enabled")).color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)" "))).append(Component.text((String)Language.getMessage(this.lang, "plugin-autobind-binding")).color((TextColor)NamedTextColor.YELLOW)));
        boolean isBound = this.plugin.bind(playerBindKey, player);
        if (!isBound) {
            player.sendMessage(Component.text((String)Language.getMessage(this.lang, "plugin-autobind-failed")).color((TextColor)NamedTextColor.RED));
        }
    }
}

