/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.velocity.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.proxy.Player;
import io.greitan.avion.velocity.GeyserVoice;
import io.greitan.avion.velocity.utils.Language;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class PlayerQuitHandler {
    private final GeyserVoice plugin;
    private final String lang;

    public PlayerQuitHandler(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    @Subscribe
    public void onPlayerQuit(DisconnectEvent event) {
        Player player = event.getPlayer();
        boolean isBound = this.plugin.getPlayerBinds().getOrDefault(player.getUsername(), false);
        if (this.plugin.isConnected() && isBound) {
            this.handlePlayerDisconnect(player);
        }
    }

    private void handlePlayerDisconnect(Player player) {
        boolean isDisconnected = this.plugin.disconnectPlayer(player);
        this.plugin.playerDataList.remove(player.getUniqueId().toString());
        String playerName = player.getUsername();
        String disconnectMessage = Language.getMessage(this.lang, "player-disconnect-success").replace("$player", playerName);
        if (isDisconnected) {
            this.plugin.Logger.info(disconnectMessage);
            boolean sendDisconnectMessage = GeyserVoice.getConfig().getBoolean("config.voice.send-disconnect-message");
            if (sendDisconnectMessage) {
                this.plugin.getProxy().sendMessage(Component.text((String)disconnectMessage).color((TextColor)NamedTextColor.YELLOW));
            }
        } else {
            this.plugin.Logger.error(Language.getMessage(this.lang, "player-disconnect-failed").replace("$player", playerName));
            this.plugin.getPlayerBinds().remove(playerName);
        }
    }
}

