/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.velocity.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import io.greitan.avion.common.network.Payloads;
import io.greitan.avion.velocity.GeyserVoice;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class PluginMessageHandler {
    private final GeyserVoice plugin;
    public static final MinecraftChannelIdentifier channelName = MinecraftChannelIdentifier.from((String)"geyservoice:main");

    public PluginMessageHandler(GeyserVoice plugin) {
        this.plugin = plugin;
    }

    public Boolean sendPlayerBindSync(Player player) {
        boolean isBound = this.plugin.isConnected() && this.plugin.getPlayerBinds().getOrDefault(player.getUsername(), false) != false;
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("PlayerBindSync");
        out.writeUTF(player.getUsername());
        out.writeBoolean(isBound);
        return this.trySendMessage(player, out);
    }

    public Boolean trySendMessage(Player player, ByteArrayDataOutput out) {
        Optional connection = player.getCurrentServer();
        if (connection.isPresent()) {
            try {
                if (((ServerConnection)connection.get()).sendPluginMessage((ChannelIdentifier)channelName, out.toByteArray())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (((ServerConnection)connection.get()).getServer().sendPluginMessage((ChannelIdentifier)channelName, out.toByteArray())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Player otherPlayer : this.plugin.getProxy().getAllPlayers()) {
            connection = otherPlayer.getCurrentServer();
            if (!connection.isPresent()) continue;
            try {
                if (!((ServerConnection)connection.get()).sendPluginMessage((ChannelIdentifier)channelName, out.toByteArray())) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        for (RegisteredServer server : this.plugin.getProxy().getAllServers()) {
            server.sendPluginMessage((ChannelIdentifier)channelName, out.toByteArray());
        }
        return true;
    }

    @Subscribe
    public void onMessageReceived(PluginMessageEvent event) {
        if (event.getIdentifier() != channelName) {
            return;
        }
        if (!(event.getSource() instanceof ServerConnection)) {
            return;
        }
        ServerConnection backend = (ServerConnection)event.getSource();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
        String subchannel = in.readUTF();
        String serverName = backend.getServerInfo().getName();
        if (subchannel.equals("PlayerDataList")) {
            String rawPlayerDataList = in.readUTF();
            this.plugin.Logger.debug("Received playerdatalist: " + rawPlayerDataList);
            try {
                List<Payloads.PlayerData> playerDataList = Arrays.asList(GeyserVoice.objectMapper.readValue(rawPlayerDataList, Payloads.PlayerData[].class));
                for (Payloads.PlayerData playerData : playerDataList) {
                    playerData.DimensionId = serverName + "_" + playerData.DimensionId;
                    this.plugin.playerDataList.put(playerData.PlayerId, playerData);
                }
            }
            catch (JsonProcessingException jsonProcessingException) {}
        } else if (subchannel.equals("PlayerData")) {
            Payloads.PlayerData playerData = new Payloads.PlayerData();
            playerData.PlayerId = in.readUTF();
            playerData.DimensionId = in.readUTF();
            playerData.Location.x = in.readDouble();
            playerData.Location.y = in.readDouble();
            playerData.Location.z = in.readDouble();
            playerData.Rotation = in.readDouble();
            playerData.EchoFactor = in.readDouble();
            playerData.Muffled = in.readBoolean();
            playerData.IsDead = in.readBoolean();
            playerData.DimensionId = serverName + "_" + playerData.DimensionId;
            this.plugin.playerDataList.put(playerData.PlayerId, playerData);
        }
        event.setResult(PluginMessageEvent.ForwardResult.handled());
    }
}

