/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.velocity.tasks;

import io.greitan.avion.common.network.Payloads;
import io.greitan.avion.velocity.GeyserVoice;
import io.greitan.avion.velocity.utils.Language;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class PositionsTask {
    private final GeyserVoice plugin;
    private final String lang;
    private boolean isConnected = false;
    private Integer ReconnectRetries = 0;

    public PositionsTask(GeyserVoice plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    public Boolean run() {
        this.isConnected = this.plugin.isConnected();
        String host = this.plugin.getHost();
        int port = this.plugin.getPort();
        String token = this.plugin.getToken();
        String link = "http://" + host + ":" + port;
        if (this.isConnected && host != null && token != null) {
            Payloads.UpdatePacket updatePacket = new Payloads.UpdatePacket();
            updatePacket.Token = token;
            updatePacket.Players = this.getPlayerDataList(this.plugin.playerDataList);
            Payloads.MCCommPacket response = this.plugin.network.sendPostRequest(link, updatePacket);
            if (response != null) {
                if (response.PacketId == Payloads.PacketType.AckUpdate.ordinal()) {
                    return true;
                }
                if (response.PacketId == Payloads.PacketType.Deny.ordinal()) {
                    Payloads.DenyPacket packetData = GeyserVoice.objectMapper.convertValue((Object)response, Payloads.DenyPacket.class);
                    this.plugin.Logger.error(packetData.Reason);
                    if (!packetData.Reason.equals("Invalid Token!")) {
                        this.plugin.setNotConnected();
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!this.isConnected) {
                return true;
            }
            this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-lost"));
            this.plugin.setNotConnected();
            if (GeyserVoice.getConfig().getBoolean("config.auto-reconnect")) {
                if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                    this.plugin.getProxy().sendMessage(Component.text((String)Language.getMessage(this.lang, "plugin-connection-lost-reconnect")).color((TextColor)NamedTextColor.RED));
                }
                this.ReconnectRetries = 0;
                return this.Reconnect();
            }
            if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                this.plugin.getProxy().sendMessage(Component.text((String)Language.getMessage(this.lang, "plugin-connection-lost")).color((TextColor)NamedTextColor.RED));
            }
            return false;
        }
        return true;
    }

    public List<Payloads.PlayerData> getPlayerDataList(Map<String, Payloads.PlayerData> allPlayerDataList) {
        ArrayList<Payloads.PlayerData> playerDataList = new ArrayList<Payloads.PlayerData>();
        for (String playerId : allPlayerDataList.keySet()) {
            playerDataList.add(allPlayerDataList.get(playerId));
        }
        return playerDataList;
    }

    private Boolean Reconnect() {
        if (this.ReconnectRetries < 5) {
            Integer n = this.ReconnectRetries;
            this.ReconnectRetries = this.ReconnectRetries + 1;
            this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-attempt").replace("$attempt", this.ReconnectRetries.toString()));
            if (this.plugin.reconnect(true).booleanValue()) {
                this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-success"));
                if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                    this.plugin.getProxy().sendMessage(Component.text((String)Language.getMessage(this.lang, "plugin-connection-reconnecting-success")).color((TextColor)NamedTextColor.GREEN));
                }
                return true;
            }
            if (this.ReconnectRetries < 5) {
                this.plugin.Logger.warn(Language.getMessage(this.lang, "plugin-connection-reconnecting-failed-retry"));
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.Reconnect();
            }
            this.plugin.Logger.error(Language.getMessage(this.lang, "plugin-connection-reconnecting-failed"));
            if (GeyserVoice.getConfig().getBoolean("config.voice.send-connection-lost-message")) {
                this.plugin.getProxy().sendMessage(Component.text((String)Language.getMessage(this.lang, "plugin-connection-reconnecting-failed")).color((TextColor)NamedTextColor.RED));
            }
        }
        return false;
    }
}

