/*
 * Decompiled with CFR 0.152.
 */
package io.greitan.avion.velocity.utils;

import de.leonhard.storage.Yaml;
import io.greitan.avion.velocity.GeyserVoice;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Language {
    private static final Map<String, Yaml> languageConfigs = new HashMap<String, Yaml>();
    private static String defaultLanguage = "en";

    public static void init(GeyserVoice plugin) {
        File languageFolder = new File(plugin.getDataFolder(), "locale");
        if (!languageFolder.exists()) {
            languageFolder.mkdirs();
            plugin.saveResource("/locale/en.yml");
            plugin.saveResource("/locale/ru.yml");
            plugin.saveResource("/locale/nl.yml");
            plugin.saveResource("/locale/ja.yml");
        }
        Language.loadLanguages(languageFolder.getAbsolutePath());
    }

    private static void loadLanguages(String pluginFolder) {
        File languageFolder = new File(pluginFolder);
        if (languageFolder.exists() && languageFolder.isDirectory()) {
            for (File file : languageFolder.listFiles()) {
                if (!file.getName().endsWith(".yml")) continue;
                String language = file.getName().replace(".yml", "");
                Yaml config = new Yaml(language, pluginFolder);
                languageConfigs.put(language, config);
            }
        }
    }

    public static String getMessage(String language, String key) {
        Yaml config;
        if (languageConfigs.containsKey(language) && (config = languageConfigs.get(language)).contains("messages." + key)) {
            return config.getString("messages." + key);
        }
        return languageConfigs.get(defaultLanguage).getString("messages." + key);
    }
}

