/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.renether.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.renether.init.RenetherModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class RenetherModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
        Registry levelStemTypeRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().registryOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            DimensionType dimensionType = (DimensionType)levelStem.type().value();
            if (dimensionType != dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.NETHER)) continue;
            ChunkGenerator chunkGenerator = levelStem.generator();
            BiomeSource biomeSource = chunkGenerator.getBiomeSource();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>(noiseSource.parameters().values());
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.25f, (float)0.5f), Climate.Parameter.span((float)-1.0f, (float)-0.25f), Climate.Parameter.span((float)0.3f, (float)0.75f), Climate.Parameter.span((float)-0.33f, (float)0.66f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)0.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_fields")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.25f, (float)0.5f), Climate.Parameter.span((float)-1.0f, (float)-0.25f), Climate.Parameter.span((float)0.3f, (float)0.75f), Climate.Parameter.span((float)-0.33f, (float)0.66f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)0.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_fields")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.5f, (float)1.0f), Climate.Parameter.span((float)0.33f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)0.35f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"crimson_jungle")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.5f, (float)1.0f), Climate.Parameter.span((float)0.33f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)0.35f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"crimson_jungle")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.66f, (float)0.33f), Climate.Parameter.span((float)-0.5f, (float)0.25f), Climate.Parameter.span((float)-0.25f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)-0.33f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.33f, (float)0.66f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"luminescent_cavern")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.66f, (float)0.33f), Climate.Parameter.span((float)-0.5f, (float)0.25f), Climate.Parameter.span((float)-0.25f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)-0.33f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.33f, (float)0.66f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"luminescent_cavern")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)-0.66f), Climate.Parameter.span((float)0.5f, (float)0.85f), Climate.Parameter.span((float)-0.5f, (float)0.25f), Climate.Parameter.span((float)0.0f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"warped_grove")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)-0.66f), Climate.Parameter.span((float)0.5f, (float)0.85f), Climate.Parameter.span((float)-0.5f, (float)0.25f), Climate.Parameter.span((float)0.0f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"warped_grove")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.66f, (float)1.0f), Climate.Parameter.span((float)-0.25f, (float)0.5f), Climate.Parameter.span((float)0.33f, (float)0.75f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_forest")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.66f, (float)1.0f), Climate.Parameter.span((float)-0.25f, (float)0.5f), Climate.Parameter.span((float)0.33f, (float)0.75f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_forest")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.75f, (float)-0.25f), Climate.Parameter.span((float)0.0f, (float)1.0f), Climate.Parameter.span((float)0.0f, (float)0.66f), Climate.Parameter.span((float)0.5f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)0.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"tar_pits")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.75f, (float)-0.25f), Climate.Parameter.span((float)0.0f, (float)1.0f), Climate.Parameter.span((float)0.0f, (float)0.66f), Climate.Parameter.span((float)0.5f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)0.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"tar_pits")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)0.0f), Climate.Parameter.span((float)-1.0f, (float)-0.25f), Climate.Parameter.span((float)0.0f, (float)0.3f), Climate.Parameter.span((float)-0.66f, (float)-0.33f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)0.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_garden")))));
                RenetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)0.0f), Climate.Parameter.span((float)-1.0f, (float)-0.25f), Climate.Parameter.span((float)0.0f, (float)0.3f), Climate.Parameter.span((float)-0.66f, (float)-0.33f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)0.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_garden")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
            SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.surfaceRule();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.sequence());
            RenetherModBiomes.addSurfaceRule(surfaceRules, 2, RenetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_fields")), ((Block)RenetherModBlocks.ASH.get()).defaultBlockState(), ((Block)RenetherModBlocks.PACKED_ASH.get()).defaultBlockState(), ((Block)RenetherModBlocks.PACKED_ASH.get()).defaultBlockState()));
            RenetherModBiomes.addSurfaceRule(surfaceRules, 2, RenetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"crimson_jungle")), Blocks.CRIMSON_NYLIUM.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
            RenetherModBiomes.addSurfaceRule(surfaceRules, 2, RenetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"luminescent_cavern")), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
            RenetherModBiomes.addSurfaceRule(surfaceRules, 2, RenetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"warped_grove")), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
            RenetherModBiomes.addSurfaceRule(surfaceRules, 2, RenetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_forest")), Blocks.CRIMSON_NYLIUM.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
            RenetherModBiomes.addSurfaceRule(surfaceRules, 2, RenetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"tar_pits")), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
            RenetherModBiomes.addSurfaceRule(surfaceRules, 2, RenetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"renether", (String)"ashen_garden")), ((Block)RenetherModBlocks.ASH.get()).defaultBlockState(), ((Block)RenetherModBlocks.PACKED_ASH.get()).defaultBlockState(), ((Block)RenetherModBlocks.PACKED_ASH.get()).defaultBlockState()));
            NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.noiseSettings(), noiseGeneratorSettings.defaultBlock(), noiseGeneratorSettings.defaultFluid(), noiseGeneratorSettings.noiseRouter(), SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.spawnTarget(), noiseGeneratorSettings.seaLevel(), noiseGeneratorSettings.disableMobGeneration(), noiseGeneratorSettings.aquifersEnabled(), noiseGeneratorSettings.oreVeinsEnabled(), noiseGeneratorSettings.useLegacyRandomSource());
            noiseGenerator.settings = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))}));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    private static void addSurfaceRule(List<SurfaceRules.RuleSource> surfaceRules, int index, SurfaceRules.RuleSource rule) {
        if (!surfaceRules.contains(rule)) {
            if (index >= surfaceRules.size()) {
                surfaceRules.add(rule);
            } else {
                surfaceRules.add(index, rule);
            }
        }
    }
}

