/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.renether.init;

import net.mcreator.renether.entity.BlastingChargeEntityEntity;
import net.mcreator.renether.entity.DamnedEntity;
import net.mcreator.renether.entity.FlickerEntity;
import net.mcreator.renether.entity.GullacanthEntity;
import net.mcreator.renether.entity.LostSoulEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RenetherModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"renether");
    public static final DeferredHolder<EntityType<?>, EntityType<DamnedEntity>> DAMNED = RenetherModEntities.register("damned", EntityType.Builder.of(DamnedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LostSoulEntity>> LOST_SOUL = RenetherModEntities.register("lost_soul", EntityType.Builder.of(LostSoulEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(72).setUpdateInterval(3).fireImmune().sized(0.3f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlastingChargeEntityEntity>> BLASTING_CHARGE_ENTITY = RenetherModEntities.register("blasting_charge_entity", EntityType.Builder.of(BlastingChargeEntityEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<GullacanthEntity>> GULLACANTH = RenetherModEntities.register("gullacanth", EntityType.Builder.of(GullacanthEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.5f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<FlickerEntity>> FLICKER = RenetherModEntities.register("flicker", EntityType.Builder.of(FlickerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        DamnedEntity.init(event);
        LostSoulEntity.init(event);
        BlastingChargeEntityEntity.init(event);
        GullacanthEntity.init(event);
        FlickerEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DAMNED.get(), DamnedEntity.createAttributes().build());
        event.put((EntityType)LOST_SOUL.get(), LostSoulEntity.createAttributes().build());
        event.put((EntityType)BLASTING_CHARGE_ENTITY.get(), BlastingChargeEntityEntity.createAttributes().build());
        event.put((EntityType)GULLACANTH.get(), GullacanthEntity.createAttributes().build());
        event.put((EntityType)FLICKER.get(), FlickerEntity.createAttributes().build());
    }
}

