package com.mythicmetalsdecorations;

import com.mythicmetals.block.MythicBlocks;
import com.mythicmetalsdecorations.blocks.MythicDecorationSet;
import com.mythicmetalsdecorations.item.MythicDecorationsArmorMaterials;
import com.mythicmetalsdecorations.item.MythicDecorationsCrownMaterials;
import com.mythicmetalsdecorations.utils.RegHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_6880;

@SuppressWarnings("CodeBlock2Expr")
public class MythicDecorations {
    // FIXME - make this within Mythic Metals public or something
    private static final int CROWN_DURA_MOD = 12;

    private static final class_2960 STONE_MINING_LEVEL = class_2960.method_60654("minecraft:needs_stone_tool");
    private static final class_2960 IRON_MINING_LEVEL = class_2960.method_60654("minecraft:needs_iron_tool");
    private static final class_2960 DIAMOND_MINING_LEVEL = class_2960.method_60654("minecraft:needs_diamond_tool");
    private static final class_2960 NETHERITE_MINING_LEVEL = class_2960.method_60654("fabric:needs_tool_level_4");

    public static final MythicDecorationSet ADAMANTITE = MythicDecorationSet.Builder.begin("adamantite", false)
            .createDefaultSet(6.0F, 12F, DIAMOND_MINING_LEVEL, 162)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.ADAMANTITE), 30 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet AQUARIUM = MythicDecorationSet.Builder.begin("aquarium", false)
            .createDefaultSet(4.0F, IRON_MINING_LEVEL, 54)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.AQUARIUM), 20 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet BANGLUM = MythicDecorationSet.Builder.begin("banglum", false)
            .createDefaultSet(5.0F, 10F, IRON_MINING_LEVEL, 54)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.BANGLUM), 14 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet BRONZE = MythicDecorationSet.Builder.begin("bronze", false)
            .createDefaultSet(5.0F, IRON_MINING_LEVEL, 63).finish();
    public static final MythicDecorationSet CARMOT = MythicDecorationSet.Builder.begin("carmot", false)
            .createDefaultSet(5.5F, IRON_MINING_LEVEL, 108)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.CARMOT), 26 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet CELESTIUM = MythicDecorationSet.Builder.begin("celestium", false)
            .createDefaultSet(10F, 25F, NETHERITE_MINING_LEVEL, 216)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.CELESTIUM), settings -> {
                settings.group(MythicMetalsDecorations.MYTHICMETALS_DECOR).method_7895(41 * CROWN_DURA_MOD).method_24359().method_7894(class_1814.field_8903);
            })
            .finish();
    public static final MythicDecorationSet DURASTEEL = MythicDecorationSet.Builder.begin("durasteel", false)
            .createDefaultSet(5.0F, IRON_MINING_LEVEL, 108)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.DURASTEEL), 25 * CROWN_DURA_MOD, false)
            .finish();

    public static final MythicDecorationSet HYDRARGYM = MythicDecorationSet.Builder.begin("hydrargym", false)
            .createDefaultSet(5.5F, DIAMOND_MINING_LEVEL, 162)
            .createRegalSet(MythicDecorationsArmorMaterials.HYDRARGYM, 30)
            .finish();

    // TODO - Consider refactoring this
    public static final class_2248 HYDRARGYM_BLOCK = new class_2248(class_4970.class_2251.method_9630(MythicBlocks.MYTHRIL.getStorageBlock()));
    public static final class_1792 HYDRARGYM_NUGGET = new class_1792(new class_1792.class_1793().group(MythicMetalsDecorations.MYTHICMETALS_DECOR).tab(2));
    public static final MythicDecorationSet HALLOWED = MythicDecorationSet.Builder.begin("hallowed", false)
            .createDefaultSet(6.0F, DIAMOND_MINING_LEVEL, 162)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.HALLOWED), settings -> {
                settings.group(MythicMetalsDecorations.MYTHICMETALS_DECOR).method_7895(41 * CROWN_DURA_MOD).method_7894(class_1814.field_8907);
            })
            .finish();
    public static final MythicDecorationSet KYBER = MythicDecorationSet.Builder.begin("kyber", false)
            .createDefaultSet(4.0F, IRON_MINING_LEVEL, 81)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.KYBER), 21 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet MANGANESE = MythicDecorationSet.Builder.begin("manganese", false)
            .createDefaultSet(3.0F, IRON_MINING_LEVEL, 54)
            .createCrown(class_6880.method_40223(MythicDecorationsArmorMaterials.MANGANESE), 15 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet METALLURGIUM = MythicDecorationSet.Builder.begin("metallurgium", true)
            .createDefaultSet(55F, 15000F, NETHERITE_MINING_LEVEL, 216)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.METALLURGIUM), settings -> {
                settings
                    .group(MythicMetalsDecorations.MYTHICMETALS_DECOR)
                    .method_24359()
                    .method_7895(CROWN_DURA_MOD * 69)
                    .method_7894(class_1814.field_8903);
            })
            .finish();
    public static final MythicDecorationSet MIDAS_GOLD = MythicDecorationSet.Builder.begin("midas_gold", false)
            .createDefaultSet(5.0F, IRON_MINING_LEVEL, 81).finish();
    public static final MythicDecorationSet MYTHRIL = MythicDecorationSet.Builder.begin("mythril", false)
            .createDefaultSet(5.5F, DIAMOND_MINING_LEVEL, 162)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.MYTHRIL), 31 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet ORICHALCUM = MythicDecorationSet.Builder.begin("orichalcum", false)
            .createDefaultSet(6.0F, DIAMOND_MINING_LEVEL, 162)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.ORICHALCUM), 40 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet OSMIUM = MythicDecorationSet.Builder.begin("osmium", false)
            .createDefaultSet(4.5F, IRON_MINING_LEVEL, 81)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.OSMIUM), 25 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet PALLADIUM = MythicDecorationSet.Builder.begin("palladium", true)
            .createDefaultSet(6.0F, DIAMOND_MINING_LEVEL, 162)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.PALLADIUM), 28 * CROWN_DURA_MOD, true)
            .finish();
    public static final MythicDecorationSet PLATINUM = MythicDecorationSet.Builder.begin("platinum", false)
            .createDefaultSet(4.0F, IRON_MINING_LEVEL, 81)
            .createRegalSet(MythicDecorationsArmorMaterials.PLATINUM, 20)
            .finish();
    public static final MythicDecorationSet PROMETHEUM = MythicDecorationSet.Builder.begin("prometheum", false)
            .createDefaultSet(5.0F, IRON_MINING_LEVEL, 108).finish();
    public static final MythicDecorationSet QUADRILLUM = MythicDecorationSet.Builder.begin("quadrillum", false)
            .createDefaultSet(5.0F, STONE_MINING_LEVEL, 63).finish();
    public static final MythicDecorationSet RUNITE = MythicDecorationSet.Builder.begin("runite", false)
            .createDefaultSet(5.0F, IRON_MINING_LEVEL, 108)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.RUNITE), 27 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet SILVER = MythicDecorationSet.Builder.begin("silver", false)
            .createDefaultSet(4.0F, STONE_MINING_LEVEL, 54).finish();
    public static final MythicDecorationSet STAR_PLATINUM = MythicDecorationSet.Builder.begin("star_platinum", false)
            .createDefaultSet(5.5F, DIAMOND_MINING_LEVEL, 135)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.STAR_PLATINUM), 34 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet STEEL = MythicDecorationSet.Builder.begin("steel", false)
            .createDefaultSet(5.0F, IRON_MINING_LEVEL, 81)
            .createCrown(class_6880.method_40223(MythicDecorationsCrownMaterials.STEEL), 20 * CROWN_DURA_MOD, false)
            .finish();
    public static final MythicDecorationSet STORMYX = MythicDecorationSet.Builder.begin("stormyx", false)
            .createDefaultSet(6.0F, IRON_MINING_LEVEL, 108).finish();

    public static void init() {
        MythicDecorationSet.Builder.register();
        RegHelper.item("hydrargym_nugget", HYDRARGYM_NUGGET);
        RegHelper.block("hydrargym_block", HYDRARGYM_BLOCK);
    }
}
