package com.mythicmetalsdecorations;

import io.wispforest.endec.Endec;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.registration.reflect.FieldRegistrationHandler;
import io.wispforest.owo.serialization.CodecUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2583;
import net.minecraft.class_3917;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.registry.*;
import com.mythicmetals.ability.Abilities;
import com.mythicmetalsdecorations.blocks.chest.MythicChests;
import com.mythicmetalsdecorations.config.MythicDecorationsConfig;
import com.mythicmetalsdecorations.item.MythicDecorationsItems;
import com.mythicmetalsdecorations.screen.MythicChestScreenHandler;
import com.mythicmetalsdecorations.utils.RegHelper;

public class MythicMetalsDecorations implements ModInitializer {

    public static final String MOD_ID = "mythicmetals_decorations";
    public static MythicDecorationsConfig CONFIG = MythicDecorationsConfig.createAndLoad();
    public static final OwoItemGroup MYTHICMETALS_DECOR = OwoItemGroup.builder(RegHelper.id("main"),
                    () -> Icon.of(MythicDecorations.CELESTIUM.getChain().method_8389().method_7854()))
            .initializer(group -> {
                group.addTab(Icon.of(MythicDecorations.ADAMANTITE.getChain()), "chains", class_6862.method_40092(class_7924.field_41197, RegHelper.id("chains")), false);
                group.addTab(Icon.of(MythicDecorations.MIDAS_GOLD.getChest()), "chests", class_6862.method_40092(class_7924.field_41197, RegHelper.id("chests")), false);
                group.addTab(Icon.of(MythicDecorationsItems.HYDRARGYM_INGOT), "misc", class_6862.method_40092(class_7924.field_41197, RegHelper.id("misc")), false);

                group.addButton(ItemGroupButton.github(group, "https://github.com/Noaaan/MythicMetalsDecorations/issues"));
                group.addButton(ItemGroupButton.curseforge(group, "https://www.curseforge.com/minecraft/mc-mods/mythicmetals-decorations"));
                group.addButton(ItemGroupButton.modrinth(group, "https://modrinth.com/mod/mythicmetals_decorations"));
                group.addButton(ItemGroupButton.discord(group, "https://discord.gg/69cKvQWScC"));
            })
        .disableDynamicTitle()
        .build();

    public static final class_3917<MythicChestScreenHandler> MYTHIC_CHEST_SCREEN_HANDLER_TYPE = new ExtendedScreenHandlerType<>(MythicChestScreenHandler::new, CodecUtils.toPacketCodec(Endec.INT));

    public static final class_1792 CROWN_CHISEL = new class_1792(new class_1792.class_1793().group(MYTHICMETALS_DECOR).tab(2));

    @Override
    public void onInitialize() {
        MythicDecorations.init();
        MythicChests.init();
        FieldRegistrationHandler.register(MythicDecorationsItems.class, MOD_ID, false);
        MYTHICMETALS_DECOR.initialize();

        // Integrate with base MM
        Abilities.BLAST_PADDING.addItem(MythicDecorations.BANGLUM.getCrown(), class_2583.field_24360.method_10977(class_124.field_1065));
        Abilities.FIRE_PROTECTION.addItem(MythicDecorations.PALLADIUM.getCrown(), class_2583.field_24360.method_36139(14644003));

        class_2378.method_10230(class_7923.field_41187, RegHelper.id("mythic_chest"), MYTHIC_CHEST_SCREEN_HANDLER_TYPE);
        class_2378.method_10230(class_7923.field_41178, RegHelper.id("crown_chisel"), CROWN_CHISEL);
    }

}
