package com.mythicmetalsdecorations.blocks.chest;

import com.mythicmetalsdecorations.client.MythicMetalsDecorationsClient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2745;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_5607;

public class ChestTextureLayers {
    public static List<class_5601> modelList = new ArrayList<>();
    public static Map<String, class_4730> chestSpriteMap = new HashMap<>();

    /**
     * For each entry in the list assign it a model
     * The list of models is created in order by single chest, left double chest, right double chest
     * @param consumer A bi-consumer for registering the modellayers is passed here
     */
    public static void init(BiConsumer<class_5601, class_5607> consumer) {

        for (int i = 0; i < modelList.size(); i++) {
            if (i % 3 == 0) {
                consumer.accept(modelList.get(i), MythicChestBlockEntityRenderer.getSingleTexturedModelData());
            }
            if (i % 3 == 1) {
                consumer.accept(modelList.get(i), MythicChestBlockEntityRenderer.getLeftDoubleTexturedModelData());
            }
            if (i % 3 == 2) {
                consumer.accept(modelList.get(i), MythicChestBlockEntityRenderer.getRightDoubleTexturedModelData());
            }

        }
    }

    /**
     * Returns a specific chest sprite from our chest sprite map
     * This is filled during {@link MythicMetalsDecorationsClient#createChestModelsAndSprites()}
     * @param name  The name of the chest, stored in {@link MythicChestBlock} and {@link MythicChestBlockEntity}
     * @param type  The {@link class_2745} of the current chest
     * @return      The sprite in the map
     */
    public static class_4730 getChestIdentifier(String name, class_2745 type) {
        return chestSpriteMap.get(name + type.name());
    }

}
