package com.mythicmetalsdecorations.screen;

import io.wispforest.owo.mixin.ui.SlotAccessor;
import io.wispforest.owo.util.pond.OwoSlotExtension;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import com.mythicmetalsdecorations.MythicMetalsDecorations;
import com.mythicmetalsdecorations.utils.RegHelper;

public class MythicChestScreen extends class_465<MythicChestScreenHandler> {

    public static final class_2960 TEXTURE = RegHelper.id("textures/gui/mythic_chest_screen.png");

    private ChestScreenSize size;

    private boolean scrolling = false;
    private int scrollOffset = 0;
    private int maxScroll = 0;

    public MythicChestScreen(MythicChestScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void method_25426() {
        this.size = ChestScreenSize.decompose(field_2797.inventorySize(), this.field_22789 - 8, this.field_22790 - 8);

        this.field_2792 = this.size.paddedWidth();
        this.field_2779 = this.size.paddedHeight() + ChestScreenSize.PLAYER_INVENTORY_HEIGHT;

        this.field_25270 = this.field_2779 - 94;

        this.maxScroll = this.size.hasExtraRow()
                ? (this.field_2797.inventorySize() - this.size.rows() * this.size.columns()) / this.size.columns() + 1
                : (this.field_2797.inventorySize() - this.size.rows() * this.size.columns()) / this.size.columns();
        this.scrollOffset = class_3532.method_15340(this.scrollOffset, 0, this.maxScroll);

        this.configureSlots(true);

        super.method_25426();
    }

    private void configureSlots(boolean movePlayerInventory) {
        int pointer = 0;

        for (int i = 0; i < this.scrollOffset * this.size.columns(); i++) {
            this.toggleSlot(this.field_2797.method_7611(i), false);

            pointer++;
        }

        // Arrange visible chest slots
        arrange:
        for (int row = 0; row < this.size.rows(); row++) {
            for (int column = 0; column < this.size.columns(); column++) {
                var slot = this.field_2797.method_7611(pointer);
                this.toggleSlot(slot, true);
                this.moveSlot(slot, 8 + column * 18, 18 + row * 18);

                pointer++;
                if (pointer >= this.field_2797.chestInventory().method_5439()) break arrange;
            }
        }

        // Hide overflowing slots
        for (int i = pointer; i < this.field_2797.chestInventory().method_5439(); i++) {
            this.toggleSlot(this.field_2797.method_7611(i), false);

            pointer++;
        }

        if (movePlayerInventory) {
            // Player Inventory
            for (int row = 0; row < 3; row++) {
                for (int column = 0; column < 9; column++) {
                    var slot = this.field_2797.field_7761.get(pointer);
                    this.moveSlot(slot, this.size.playerInventoryX() + 8 + column * 18, this.size.paddedHeight() + 15 + row * 18);

                    pointer++;
                }
            }

            // Player hotbar
            for (int i = 0; i < 9; i++) {
                var slot = this.field_2797.method_7611(pointer);
                this.moveSlot(slot, this.size.playerInventoryX() + 8 + i * 18, this.size.paddedHeight() + 15 + 58);

                pointer++;
            }
        }
    }

    private void scroll(int offset) {
        this.scrollOffset = class_3532.method_15340(offset, 0, this.maxScroll);
        this.configureSlots(false);
    }

    private void moveSlot(class_1735 slot, int x, int y) {
        ((SlotAccessor) slot).owo$setX(x);
        ((SlotAccessor) slot).owo$setY(y);
    }

    // I am not scared of the ducks in the pond
    @SuppressWarnings("UnstableApiUsage")
    private void toggleSlot(class_1735 slot, boolean enabled) {
        ((OwoSlotExtension) slot).owo$setDisabledOverride(!enabled);
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        this.method_2380(drawContext, mouseX, mouseY);
    }

    @Override
    protected void method_2389(class_332 drawContext, float delta, int mouseX, int mouseY) {
        //super.renderBackground(drawContext, mouseX, mouseY, delta);

        drawContext.method_25290(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.size.width() + ChestScreenSize.HORIZONTAL_PADDING, this.size.paddedHeight(), 368, 416);
        drawContext.method_25290(TEXTURE, this.field_2776 + this.size.width() + ChestScreenSize.HORIZONTAL_PADDING, this.field_2800, 331, 0, ChestScreenSize.HORIZONTAL_PADDING, this.size.paddedHeight(), 368, 416);

        int playerInventoryX = this.size.playerInventoryX();
        drawContext.method_25290(TEXTURE, this.field_2776 + playerInventoryX, this.field_2800 + this.size.paddedHeight(), 81, 287, 176, 97, 368, 416);

        if (this.size.columns() > 9) {
            drawContext.method_25290(TEXTURE, this.field_2776, this.field_2800 + this.size.paddedHeight(), 0, 384, playerInventoryX, 17, 368, 416);
            drawContext.method_25290(TEXTURE, this.field_2776 + playerInventoryX, this.field_2800 + this.size.paddedHeight(), 81, 384, 3, 17, 368, 416);

            drawContext.method_25290(TEXTURE, this.field_2776 + playerInventoryX + 176, this.field_2800 + this.size.paddedHeight(), 257 + 81 - playerInventoryX, 384, playerInventoryX, 17, 368, 416);
            drawContext.method_25290(TEXTURE, this.field_2776 + playerInventoryX + 176 - 3, this.field_2800 + this.size.paddedHeight(), 254, 384, 3, 17, 368, 416);
        }

        if (this.scrollOffset == this.maxScroll && (this.size.hasExtraRow() || this.size.rows() * this.size.columns() > this.field_2797.inventorySize())) {
            var finalRowSlots = this.size.hasExtraRow() ? this.size.extraRowSlots() : (this.field_2797.inventorySize()) % this.size.columns();
            drawContext.method_25293(TEXTURE,
                    this.field_2776 + ChestScreenSize.HORIZONTAL_PADDING + finalRowSlots * 18, this.field_2800 + this.size.paddedHeight() - 18,
                    this.size.width() - (finalRowSlots * 18), 18,
                    339, 287, 14, 14,
                    368, 416
            );
        }

        if (this.size.needsScrolling()) {
            drawContext.method_25290(TEXTURE, this.field_2776 + this.size.paddedWidth() - 4, this.field_2800, 338, 0, 22, this.size.paddedHeight(), 368, 416);
            if (this.size.columns() > 9) {
                drawContext.method_25290(TEXTURE, this.field_2776 + this.size.paddedWidth() - 4, this.field_2800 + size.paddedHeight() - 1, 338, 286, 22, 18, 368, 416);
                drawContext.method_25290(TEXTURE, this.field_2776 + this.size.paddedWidth() - 2, this.field_2800 + 18 + this.scrollOffset * (this.size.paddedHeight() - 34) / this.maxScroll, 338, 322, 12, 15, 368, 416);
            } else {
                drawContext.method_25290(TEXTURE, this.field_2776 + this.size.paddedWidth() - 4, this.field_2800 + size.paddedHeight() - 18, 338, 304, 22, 18, 368, 416);
                drawContext.method_25290(TEXTURE, this.field_2776 + this.size.paddedWidth() - 2, this.field_2800 + 18 + this.scrollOffset * (this.size.paddedHeight() - 51) / this.maxScroll, 338, 322, 12, 15, 368, 416);
            }
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            this.scrollTo(mouseY);
            return true;
        } else {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isInScrollbar(mouseX, mouseY)) {
            this.scrolling = true;
            this.scrollTo(mouseY);
            return true;
        } else {
            this.scrolling = false;
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    private void scrollTo(double mouseY) {
        double scrollbarTop = this.field_2800 + ChestScreenSize.TOP_PADDING + 1;
        double scrollbarBottom = this.size.rows() * 18 + (this.size.columns() > 9 ? 17 : 0);

        this.scroll((int) (((mouseY - scrollbarTop) / (scrollbarBottom - scrollbarTop)) * this.maxScroll));
    }

    private boolean isInScrollbar(double mouseX, double mouseY) {
        return mouseX >= this.field_2776 + this.size.paddedWidth() - 2
                && mouseX <= this.field_2776 + this.size.paddedWidth() + 10
                && mouseY >= this.field_2800 + ChestScreenSize.TOP_PADDING + 1
                && mouseY <= this.field_2800 + ChestScreenSize.TOP_PADDING + 1 + this.size.rows() * 18 + (this.size.columns() > 9 ? 17 : 0);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (MythicMetalsDecorations.CONFIG.onlyScrollOnScrollbar()) {
            if (isInScrollbar(mouseX, mouseY)) {
                this.scroll((int) (this.scrollOffset - verticalAmount));
                return true;
            }
            return false;
        }
        this.scroll((int) (this.scrollOffset - verticalAmount));
        return true;
    }

    public ChestScreenSize getSize() {
        return size;
    }

    public int getHandledScreenX() {
        return this.field_2776;
    }

    public int getHandledScreenY() {
        return this.field_2800;
    }

    public int getBackgroundWidth() {
        return this.field_2792;
    }
}
