/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.fog.api.FogColors;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import org.jetbrains.annotations.Nullable;

public final class CustomFogDefinition {
    public static final Codec<CustomFogDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("start_multiplier").forGetter(CustomFogDefinition::startMultiplier), (App)Codec.FLOAT.fieldOf("end_multiplier").forGetter(CustomFogDefinition::endMultiplier), (App)FogColors.CODEC.optionalFieldOf("colors", null).forGetter(CustomFogDefinition::colors)).apply((Applicative)instance, CustomFogDefinition::new));
    private final float startMultiplier;
    private final float endMultiplier;
    @Nullable
    private final FogColors colors;

    public static CustomFogDefinition getDefault(ClientLevel world) {
        return new CustomFogDefinition(1.0f, 1.0f, FogColors.getDefault(world));
    }

    private CustomFogDefinition(float startMultiplier, float endMultiplier, @Nullable FogColors colors) {
        this.startMultiplier = startMultiplier;
        this.endMultiplier = endMultiplier;
        this.colors = colors;
    }

    public float startMultiplier() {
        return this.startMultiplier;
    }

    public float endMultiplier() {
        return this.endMultiplier;
    }

    @Nullable
    public FogColors colors() {
        return this.colors;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CustomFogDefinition that = (CustomFogDefinition)obj;
        return Float.floatToIntBits(this.startMultiplier) == Float.floatToIntBits(that.startMultiplier) && Float.floatToIntBits(this.endMultiplier) == Float.floatToIntBits(that.endMultiplier) && Objects.equals(this.colors, that.colors);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.startMultiplier), Float.valueOf(this.endMultiplier), this.colors);
    }

    public String toString() {
        return "CustomFogDefinition[startMultiplier=" + this.startMultiplier + ", endMultiplier=" + this.endMultiplier + ", colors=" + String.valueOf(this.colors) + "]";
    }

    public static class Builder {
        private float startMultiplier = CustomFogDefinition.getDefault(null).startMultiplier();
        private float endMultiplier = CustomFogDefinition.getDefault(null).endMultiplier();
        private FogColors colors = CustomFogDefinition.getDefault(null).colors();

        public static Builder create() {
            return new Builder();
        }

        public Builder startMultiplier(float startMultiplier) {
            this.startMultiplier = startMultiplier;
            return this;
        }

        public Builder endMultiplier(float endMultiplier) {
            this.endMultiplier = endMultiplier;
            return this;
        }

        public Builder colors(FogColors colors) {
            this.colors = colors;
            return this;
        }

        public Builder colors(String day, String night) {
            this.colors = new FogColors(day, night);
            return this;
        }

        public CustomFogDefinition build() {
            return new CustomFogDefinition(this.startMultiplier, this.endMultiplier, this.colors);
        }
    }
}

