/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.TickUtil;
import dev.imb11.fog.client.util.color.Color;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogClientCommands {
    public static void register() {
        ClientCommandRegistrationEvent.EVENT.register((dispatcher, context) -> {
            LiteralArgumentBuilder fogNode = ClientCommandRegistrationEvent.literal((String)"fog");
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"reset").executes(FogClientCommands::reset));
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"toggle").executes(FogClientCommands::toggle));
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"debug").executes(FogClientCommands::outputDebug));
            dispatcher.register(fogNode);
        });
    }

    private static int outputDebug(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        Minecraft client = Minecraft.getInstance();
        @Nullable ClientLevel clientWorld = client.level;
        if (clientWorld == null) {
            ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendFailure((Component)Component.translatable((String)"fog.command.debug.failure"));
            return 0;
        }
        @NotNull FogManager manager = FogManager.INSTANCE;
        float tickDelta = TickUtil.getTickDelta();
        @NotNull Color fogColor = new Color((int)(manager.fogColorRed.get(tickDelta) * 255.0f), (int)(manager.fogColorGreen.get(tickDelta) * 255.0f), (int)(manager.fogColorBlue.get(tickDelta) * 255.0f));
        @NotNull String fogColorHex = String.format("#\u00a7c%02x\u00a7a%02x\u00a79%02x", fogColor.red, fogColor.green, fogColor.blue);
        @NotNull String debugInfoTable = String.format("\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Fog Manager State:\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Raininess: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r \"Undergroundness\": \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog Start: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog End: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Darkness: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog Color: \u00a76%s\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Sky Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Block Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Start Multiplier: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current End Multiplier: \u00a76%.2f\u00a7r", Float.valueOf(manager.raininess.get(tickDelta)), Float.valueOf(manager.undergroundness.get(tickDelta)), Float.valueOf(manager.fogStart.get(tickDelta)), Float.valueOf(manager.fogEnd.get(tickDelta)), Float.valueOf(manager.darkness.get(tickDelta)), fogColorHex, Float.valueOf(manager.currentSkyLight.get(tickDelta)), Float.valueOf(manager.currentBlockLight.get(tickDelta)), Float.valueOf(manager.currentLight.get(tickDelta)), Float.valueOf(manager.currentStartMultiplier.get(tickDelta)), Float.valueOf(manager.currentEndMultiplier.get(tickDelta)));
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> Component.literal((String)debugInfoTable), false);
        return 1;
    }

    private static int reset(@NotNull CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        FogConfig.load();
        FogManager.INSTANCE = new FogManager();
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> Component.literal((String)"\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r ").append((Component)Component.translatable((String)"fog.command.reset").withStyle(ChatFormatting.GOLD)), false);
        return 1;
    }

    public static int toggle(@NotNull CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        FogConfig config = FogConfig.getInstance();
        config.enableMod = !config.enableMod;
        FogConfig.save();
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> Component.literal((String)"\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r ").append((Component)Component.translatable((String)("fog.command.toggle." + (config.enableMod ? "enabled" : "disabled"))).withStyle(ChatFormatting.GOLD)), false);
        return 1;
    }
}

