/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.math;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record DarknessCalculation(float fogStart, float fogEnd, float darknessValue) {
    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static DarknessCalculation of(@NotNull Minecraft client, float fogStart, float fogEnd, float deltaTick) {
        MobEffectInstance effect;
        float renderDistance = client.gameRenderer.getRenderDistance();
        Entity entity = client.getCameraEntity();
        float darknessValue = 0.0f;
        if (!(entity instanceof LivingEntity)) {
            return new DarknessCalculation(fogStart, fogEnd, darknessValue);
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.hasEffect(MobEffects.BLINDNESS)) {
            fogStart = 64.0f / renderDistance;
            fogEnd = 128.0f / renderDistance;
            darknessValue = 1.0f;
        } else if (livingEntity.hasEffect(MobEffects.DARKNESS) && (effect = livingEntity.getEffect(MobEffects.DARKNESS)) != null) {
            float factor = ((Double)client.options.darknessEffectScale().get()).floatValue();
            float intensity = effect.getBlendFactor(livingEntity, deltaTick) * factor;
            float darknessScale = DarknessCalculation.calculateDarknessScale(livingEntity, deltaTick);
            fogStart = 128.0f / renderDistance * (1.0f - darknessScale);
            fogEnd = 240.0f / renderDistance;
            darknessValue = intensity;
        }
        return new DarknessCalculation(fogStart, fogEnd, darknessValue);
    }

    private static float calculateDarknessScale(@NotNull LivingEntity entity, float deltaTick) {
        float darknessFactor = entity.getEffect(MobEffects.DARKNESS).getBlendFactor(entity, deltaTick);
        float factor = 0.45f * darknessFactor;
        return Math.max(0.0f, Mth.cos((float)(((float)entity.tickCount - deltaTick) * (float)Math.PI * 0.025f)) * factor);
    }
}

