/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.mixin.client.rendering;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.compat.polytone.IrisCompat;
import dev.imb11.fog.client.util.TickUtil;
import dev.imb11.fog.client.util.math.EnvironmentCalculations;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.world.level.material.FogType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;IZLnet/minecraft/client/DeltaTracker;FLnet/minecraft/client/multiplayer/ClientLevel;)Lorg/joml/Vector4f;"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/CommandEncoder;mapBuffer(Lcom/mojang/blaze3d/buffers/GpuBuffer;ZZ)Lcom/mojang/blaze3d/buffers/GpuBuffer$MappedView;")})
    private void fog$modifyFog(Camera camera, int viewDistance, boolean thick, DeltaTracker tickCounter, float skyDarkness, @Nullable ClientLevel world, CallbackInfoReturnable<Vector4f> cir, @Local @NotNull LocalRef<FogData> fogData) {
        Minecraft client = Minecraft.getInstance();
        if (world == null || !FogConfig.getInstance().enableMod || FogManager.isInDisabledBiome() || camera.getFluidInCamera() != FogType.NONE || IrisCompat.shouldDisableMod()) {
            return;
        }
        float tickDelta = TickUtil.getTickDelta();
        FogManager fogManager = FogManager.getInstance();
        FogManager.FogSettings fogSettings = fogManager.getFogSettings(tickDelta, viewDistance);
        if (!world.dimensionType().hasFixedTime() || !(world.effects() instanceof DimensionSpecialEffects.EndEffects)) {
            fogSettings = EnvironmentCalculations.apply(fogManager.getUndergroundFactor(client, tickDelta), fogSettings, tickDelta);
        }
        FogData customFogData = new FogData();
        customFogData.environmentalStart = ((FogData)fogData.get()).environmentalStart;
        customFogData.renderDistanceStart = (float)fogSettings.fogStart() * 16.0f;
        customFogData.environmentalEnd = ((FogData)fogData.get()).environmentalEnd;
        customFogData.renderDistanceEnd = (float)fogSettings.fogEnd() * 16.0f;
        customFogData.skyEnd = ((FogData)fogData.get()).skyEnd;
        customFogData.cloudEnd = ((FogData)fogData.get()).cloudEnd;
        fogData.set((Object)customFogData);
    }

    @Inject(method={"computeFogColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IFZ)Lorg/joml/Vector4f;"}, at={@At(value="HEAD")}, cancellable=true)
    private void fog$modifyFogColor(Camera camera, float tickDelta, ClientLevel world, int viewDistance, float skyDarkness, boolean thick, @NotNull CallbackInfoReturnable<Vector4f> cir) {
        if (world == null || !FogConfig.getInstance().enableMod || FogManager.isInDisabledBiome() || camera.getFluidInCamera() != FogType.NONE || IrisCompat.shouldDisableMod()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        FogManager fogManager = FogManager.getInstance();
        FogManager.FogSettings fogSettings = fogManager.getFogSettings(tickDelta, viewDistance);
        if (!world.dimensionType().hasFixedTime() || !(world.effects() instanceof DimensionSpecialEffects.EndEffects)) {
            fogSettings = EnvironmentCalculations.apply(fogManager.getUndergroundFactor(client, tickDelta), fogSettings, tickDelta);
        }
        cir.setReturnValue((Object)new Vector4f(fogSettings.fogRed(), fogSettings.fogGreen(), fogSettings.fogBlue(), 1.0f));
    }
}

