/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client;

import dev.imb11.fog.api.CustomFogDefinition;
import dev.imb11.fog.api.FogColors;
import dev.imb11.fog.client.compat.polytone.PolytoneCompat;
import dev.imb11.fog.client.registry.FogRegistry;
import dev.imb11.fog.client.util.TickUtil;
import dev.imb11.fog.client.util.color.Color;
import dev.imb11.fog.client.util.math.DarknessCalculation;
import dev.imb11.fog.client.util.math.InterpolatedValue;
import dev.imb11.fog.client.util.math.MathUtil;
import dev.imb11.fog.client.util.player.PlayerUtil;
import dev.imb11.fog.client.util.world.ClientWorldUtil;
import dev.imb11.fog.config.FogConfig;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5294;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    public static FogManager INSTANCE = new FogManager();
    public final InterpolatedValue raininess;
    public final InterpolatedValue undergroundness;
    public final InterpolatedValue fogStart;
    public final InterpolatedValue fogEnd;
    public final InterpolatedValue darkness;
    public final InterpolatedValue fogColorRed;
    public final InterpolatedValue fogColorGreen;
    public final InterpolatedValue fogColorBlue;
    public final InterpolatedValue currentSkyLight;
    public final InterpolatedValue currentBlockLight;
    public final InterpolatedValue currentLight;
    public final InterpolatedValue currentStartMultiplier;
    public final InterpolatedValue currentEndMultiplier;
    public boolean hasSetup = false;

    public FogManager() {
        @NotNull FogConfig config = FogConfig.getInstance();
        this.raininess = new InterpolatedValue(0.0f, config.raininessTransitionSpeed);
        this.undergroundness = new InterpolatedValue(0.0f, config.undergroundnessTransitionSpeed);
        this.fogStart = new InterpolatedValue(config.initialFogStart, config.fogStartTransitionSpeed);
        this.fogEnd = new InterpolatedValue(config.initialFogEnd, config.fogEndTransitionSpeed);
        this.darkness = new InterpolatedValue(0.0f, config.darknessTransitionSpeed);
        this.fogColorRed = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.fogColorGreen = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.fogColorBlue = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.currentSkyLight = new InterpolatedValue(16.0f);
        this.currentBlockLight = new InterpolatedValue(16.0f);
        this.currentLight = new InterpolatedValue(16.0f);
        this.currentStartMultiplier = new InterpolatedValue(1.0f, config.startMultiplierTransitionSpeed);
        this.currentEndMultiplier = new InterpolatedValue(1.0f, config.endMultiplierTransitionSpeed);
        this.fogStart.resetTo(config.initialFogStart);
        this.fogEnd.resetTo(config.initialFogEnd);
    }

    @NotNull
    public static FogManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInDisabledBiome() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            return false;
        }
        return FogConfig.getInstance().disabledBiomes.contains(world.method_22385().method_22393(player.method_24515()).method_55840());
    }

    private static float getBlendFactor(@NotNull class_638 world) {
        long time = world.method_8532() % 24000L;
        float blendFactor = time < 11000L ? 1.0f : (time < 13000L ? MathUtil.lerp(1.0f, 0.0f, (float)(time - 11000L) / 2000.0f) : (time < 22000L ? 0.0f : (time < 23000L ? MathUtil.lerp(0.0f, 1.0f, (float)(time - 22000L) / 1000.0f) : 1.0f)));
        return blendFactor;
    }

    public void onEndTick(@NotNull class_638 clientWorld) {
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;
        if (clientPlayer == null) {
            return;
        }
        @Nullable class_2338 clientPlayerBlockPosition = clientPlayer.method_24515();
        if (clientPlayerBlockPosition == null) {
            return;
        }
        boolean isClientPlayerAboveGround = PlayerUtil.isPlayerAboveGround(clientPlayer);
        if (isClientPlayerAboveGround) {
            this.undergroundness.interpolate(0.0f);
        } else {
            this.undergroundness.interpolate(1.0f);
        }
        if (isClientPlayerAboveGround && ((class_1959)clientWorld.method_23753(clientPlayer.method_24515()).comp_349()).method_48163() && clientWorld.method_8419()) {
            this.raininess.interpolate(clientWorld.method_8546() ? 1.0f : 0.5f);
        } else {
            this.raininess.interpolate(0.0f);
        }
        float density = ClientWorldUtil.isFogDenseAtPosition(clientWorld, clientPlayerBlockPosition) ? 0.9f : 1.0f;
        float tickDelta = TickUtil.getTickDelta();
        DarknessCalculation darknessCalculation = DarknessCalculation.of(client, this.fogStart.getDefaultValue(), this.fogEnd.getDefaultValue() * density, tickDelta);
        class_6880 biomeKey = clientWorld.method_23753(clientPlayer.method_24515());
        Optional clientPlayerBiomeKeyOptional = biomeKey.method_40230();
        if (clientPlayerBiomeKeyOptional.isEmpty()) {
            return;
        }
        CustomFogDefinition fogDefinition = FogRegistry.getFogDefinitionOrDefault(((class_5321)clientPlayerBiomeKeyOptional.get()).method_29177(), clientWorld);
        @Nullable FogColors colors = fogDefinition.colors();
        if (colors == null || !FogConfig.getInstance().enableBiomeSpecificFogColors) {
            colors = FogColors.getDefault(clientWorld);
        }
        if (PolytoneCompat.shouldUsePolytone()) {
            colors = PolytoneCompat.getFogColorsFromPolytone((class_5321<class_1959>)((class_5321)clientPlayerBiomeKeyOptional.get()), colors);
        }
        float blendFactor = FogManager.getBlendFactor(clientWorld);
        Color finalNightColor = this.getFinalNightColor(clientWorld, colors);
        float red = class_3532.method_16439((float)blendFactor, (float)((float)finalNightColor.red / 255.0f), (float)((float)colors.getDayColor().red / 255.0f));
        float green = class_3532.method_16439((float)blendFactor, (float)((float)finalNightColor.green / 255.0f), (float)((float)colors.getDayColor().green / 255.0f));
        float blue = class_3532.method_16439((float)blendFactor, (float)((float)finalNightColor.blue / 255.0f), (float)((float)colors.getDayColor().blue / 255.0f));
        if (!this.hasSetup) {
            this.fogColorRed.set(red);
            this.fogColorGreen.set(green);
            this.fogColorBlue.set(blue);
            this.hasSetup = true;
        } else {
            this.fogColorRed.interpolate(red);
            this.fogColorGreen.interpolate(green);
            this.fogColorBlue.interpolate(blue);
        }
        this.currentStartMultiplier.interpolate(fogDefinition.startMultiplier());
        this.currentEndMultiplier.interpolate(fogDefinition.endMultiplier());
        this.fogStart.interpolate(darknessCalculation.fogStart());
        this.fogEnd.interpolate(darknessCalculation.fogEnd());
        this.darkness.interpolate(darknessCalculation.darknessValue());
        this.currentSkyLight.interpolate(clientWorld.method_8314(class_1944.field_9284, clientPlayerBlockPosition));
        this.currentBlockLight.interpolate(clientWorld.method_8314(class_1944.field_9282, clientPlayerBlockPosition));
        this.currentLight.interpolate(clientWorld.method_22335(clientPlayerBlockPosition, 0));
    }

    @NotNull
    private Color getFinalNightColor(@NotNull class_638 world, FogColors fogColors) {
        if (!FogConfig.getInstance().enableMoonFogColorInfluence) {
            return fogColors.getNightColor();
        }
        @NotNull Color newMoonColor = Color.from(FogConfig.getInstance().newMoonColor);
        float blendFactor = switch (world.method_30273()) {
            case 0 -> 0.0f;
            case 1, 7 -> 0.25f;
            case 2, 6 -> 0.5f;
            case 3, 5 -> 0.75f;
            case 4 -> 1.0f;
            default -> 1.0f;
        };
        return fogColors.getNightColor().lerp(newMoonColor, blendFactor);
    }

    public float getUndergroundFactor(@NotNull class_310 client, float tickDelta) {
        class_1297 clientCamera = client.method_1560();
        class_638 clientWorld = client.field_1687;
        if (clientCamera == null || clientWorld == null) {
            return 0.0f;
        }
        float clientCameraYPosition = (float)clientCamera.method_23318();
        float seaLevel = clientWorld.method_8615();
        float yFactor = class_3532.method_15363((float)MathUtil.mapRange(seaLevel - 32.0f, seaLevel + 32.0f, 1.0f, 0.0f, clientCameraYPosition), (float)0.0f, (float)1.0f);
        float undergroundnessValue = this.undergroundness.get(tickDelta);
        float skyLight = this.currentSkyLight.get(tickDelta);
        return class_3532.method_16439((float)yFactor, (float)(1.0f - undergroundnessValue), (float)(skyLight / 16.0f));
    }

    @NotNull
    public FogSettings getFogSettings(float tickDelta, float viewDistance) {
        FogConfig fogConfig = FogConfig.getInstance();
        float fogStart = this.fogStart.get(tickDelta) * this.currentStartMultiplier.get(tickDelta);
        float fogEnd = this.fogEnd.get(tickDelta) * this.currentEndMultiplier.get(tickDelta);
        float fogRed = this.fogColorRed.get(tickDelta);
        float fogGreen = this.fogColorGreen.get(tickDelta);
        float fogBlue = this.fogColorBlue.get(tickDelta);
        float[] sunriseSunsetAdjustedFogColors = this.blendFogColorWithSunriseSunsetColors(class_310.method_1551(), fogRed, fogGreen, fogBlue, tickDelta);
        fogRed = sunriseSunsetAdjustedFogColors[0];
        fogGreen = sunriseSunsetAdjustedFogColors[1];
        fogBlue = sunriseSunsetAdjustedFogColors[2];
        float darknessFogColorMultiplier = 1.0f - this.darkness.get(tickDelta);
        fogRed *= darknessFogColorMultiplier;
        fogGreen *= darknessFogColorMultiplier;
        fogBlue *= darknessFogColorMultiplier;
        float undergroundness = this.undergroundness.get(tickDelta);
        float undergroundFogMultiplier = 1.0f - undergroundness * fogConfig.undergroundFogMultiplier;
        fogStart *= undergroundFogMultiplier;
        fogEnd *= undergroundFogMultiplier;
        float rainFogMultiplier = 1.0f - Math.clamp(this.raininess.get(tickDelta) - undergroundness, 0.0f, 1.0f) * fogConfig.rainFogMultiplier;
        return new FogSettings((fogStart *= rainFogMultiplier) * viewDistance, (fogEnd *= Math.clamp(rainFogMultiplier, 0.5f, 1.0f)) * viewDistance, fogRed *= rainFogMultiplier, fogGreen *= rainFogMultiplier, fogBlue *= rainFogMultiplier);
    }

    private float[] blendFogColorWithSunriseSunsetColors(@NotNull class_310 client, float red, float green, float blue, float tickDelta) {
        class_243 sunColor;
        boolean isSunset;
        if (!FogConfig.getInstance().enableSunFogColorInfluence || client.field_1687 == null) {
            return new float[]{red, green, blue};
        }
        float skyAngle = client.field_1687.method_30274(tickDelta);
        if (client.field_1687.method_28103() instanceof class_5294.class_5297) {
            float cosAngle = class_3532.method_15362((float)(skyAngle * ((float)Math.PI * 2)));
            isSunset = cosAngle >= -0.4f && cosAngle <= 0.4f;
            float g = Math.max(cosAngle, 0.0f) / 0.4f * 0.5f + 0.5f;
            float h = 1.0f - (1.0f - class_3532.method_15374((float)(g * (float)Math.PI))) * 0.99f;
            h *= h;
            int color = (class_3532.method_15375((float)(h * 255.0f)) & 0xFF) << 24 | (class_3532.method_15375((float)((g * 0.3f + 0.7f) * 255.0f)) & 0xFF) << 16 | (class_3532.method_15375((float)((g * g * 0.7f + 0.2f) * 255.0f)) & 0xFF) << 8 | class_3532.method_15375((float)51.0f) & 0xFF;
            sunColor = class_243.method_24457((int)color);
        } else {
            isSunset = false;
            sunColor = class_243.field_1353;
        }
        if (isSunset) {
            float cosAngle = class_3532.method_15362((float)(skyAngle * ((float)Math.PI * 2)));
            float blendIntensity = 1.0f - Math.abs(cosAngle) / 0.4f;
            if ((blendIntensity = class_3532.method_15363((float)(blendIntensity * blendIntensity * (3.0f - 2.0f * blendIntensity)), (float)0.0f, (float)1.0f)) > 0.0f) {
                float sunR = (float)sunColor.field_1352;
                float sunG = (float)sunColor.field_1351;
                float sunB = (float)sunColor.field_1350;
                red = class_3532.method_16439((float)(blendIntensity * 0.7f), (float)red, (float)sunR);
                green = class_3532.method_16439((float)(blendIntensity * 0.7f), (float)green, (float)sunG);
                blue = class_3532.method_16439((float)(blendIntensity * 0.7f), (float)blue, (float)sunB);
            }
        }
        return new float[]{red, green, blue};
    }

    public record FogSettings(double fogStart, double fogEnd, float fogRed, float fogGreen, float fogBlue) {
    }
}

