/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.color;

import dev.imb11.fog.client.util.math.MathUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public class Color {
    public int red;
    public int green;
    public int blue;
    private static final int BIG_HEX_COLOR_CHARACTER_LENGTH = 6;
    private static final int SMALL_HEX_COLOR_CHARACTER_LENGTH = 3;
    private static final Map<java.awt.Color, Color> colorCache = new HashMap<java.awt.Color, Color>();

    public Color(int red, int green, int blue) {
        this.red = MathUtil.clamp(red, 0, 255);
        this.green = MathUtil.clamp(green, 0, 255);
        this.blue = MathUtil.clamp(blue, 0, 255);
    }

    public Color(int hex) {
        this.red = hex >> 16 & 0xFF;
        this.green = hex >> 8 & 0xFF;
        this.blue = hex & 0xFF;
    }

    public Color(@NotNull Color color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
    }

    public static Color from(java.awt.Color awtColor) {
        return colorCache.computeIfAbsent(awtColor, color -> new Color(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public static Color from(class_243 vec3d) {
        return new Color((int)(vec3d.field_1352 * 255.0), (int)(vec3d.field_1351 * 255.0), (int)(vec3d.field_1350 * 255.0));
    }

    public class_243 asVec3d() {
        return new class_243((double)((float)this.red / 255.0f), (double)((float)this.green / 255.0f), (double)((float)this.blue / 255.0f));
    }

    public String asHex() {
        return String.format("#%02x%02x%02x", this.red, this.green, this.blue);
    }

    public String toString() {
        return String.format("Color(%s, %s, %s)", this.red, this.green, this.blue);
    }

    @NotNull
    public static Color parse(@NotNull String hex) throws NumberFormatException {
        int blue;
        int green;
        int red;
        int hexLength;
        if ((hex = hex.trim()).startsWith("0x")) {
            hex = hex.substring(2);
            int hexValue = Integer.parseInt(hex, 16);
            return new Color(hexValue >> 16 & 0xFF, hexValue >> 8 & 0xFF, hexValue & 0xFF);
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if ((hexLength = hex.length()) == 3) {
            red = Integer.parseInt(hex.substring(0, 1), 16) * 255 / 16;
            green = Integer.parseInt(hex.substring(1, 2), 16) * 255 / 16;
            blue = Integer.parseInt(hex.substring(2, 3), 16) * 255 / 16;
        } else if (hexLength == 6) {
            red = Integer.parseInt(hex.substring(0, 2), 16);
            green = Integer.parseInt(hex.substring(2, 4), 16);
            blue = Integer.parseInt(hex.substring(4, 6), 16);
        } else {
            throw new NumberFormatException("Hex value {} was detected as the #FFF format, but it didn't have the correct amount of characters (3 or 6).");
        }
        return new Color(red, green, blue);
    }

    public int toInt() {
        int hex = this.red;
        hex = (hex << 8) + this.green;
        hex = (hex << 8) + this.blue;
        return hex;
    }

    public Color multiply(@NotNull Color color) {
        Color newColor = new Color(this);
        newColor.red = MathUtil.clamp(newColor.red * color.red, 0, 255);
        newColor.green = MathUtil.clamp(newColor.green * color.green, 0, 255);
        newColor.blue = MathUtil.clamp(newColor.blue * color.blue, 0, 255);
        return newColor;
    }

    public Color add(@NotNull Color color) {
        Color newColor = new Color(this);
        newColor.red = MathUtil.clamp(newColor.red + color.red, 0, 255);
        newColor.green = MathUtil.clamp(newColor.green + color.green, 0, 255);
        newColor.blue = MathUtil.clamp(newColor.blue + color.blue, 0, 255);
        return newColor;
    }

    public Color subtract(@NotNull Color color) {
        Color newColor = new Color(this);
        newColor.red = MathUtil.clamp(newColor.red - color.red, 0, 255);
        newColor.green = MathUtil.clamp(newColor.green - color.green, 0, 255);
        newColor.blue = MathUtil.clamp(newColor.blue - color.blue, 0, 255);
        return newColor;
    }

    public Color invert() {
        Color newColor = new Color(this);
        newColor.red = MathUtil.clamp(255 - this.red, 0, 255);
        newColor.green = MathUtil.clamp(255 - this.green, 0, 255);
        newColor.blue = MathUtil.clamp(255 - this.blue, 0, 255);
        return newColor;
    }

    public Color lerp(@NotNull Color endColor, float t) {
        Color newColor = new Color(this);
        newColor.red = MathUtil.lerp(this.red, endColor.red, t);
        newColor.green = MathUtil.lerp(this.green, endColor.green, t);
        newColor.blue = MathUtil.lerp(this.blue, endColor.blue, t);
        return newColor;
    }
}

