/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.fog.client.util.TickUtil;
import dev.imb11.fog.client.util.color.Color;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogColors {
    private static final HashMap<Class<? extends DimensionSpecialEffects>, FogColors> CACHED_DEFAULTS = new HashMap();
    public static final FogColors DEFAULT_CAVE = new FogColors("#212121", "#101010");
    public static final Codec<FogColors> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("day").forGetter(FogColors::getDay), (App)Codec.STRING.fieldOf("night").forGetter(FogColors::getNight)).apply((Applicative)instance, FogColors::new));
    @NotNull
    private final String day;
    @NotNull
    private final String night;
    @Nullable
    private transient Color dayCached;
    @Nullable
    private transient Color nightCached;

    @NotNull
    public static FogColors getDefault(@Nullable ClientLevel world) {
        if (world == null) {
            return new FogColors("#b9d2fd", "#000000");
        }
        DimensionSpecialEffects worldDimensionEffects = world.effects();
        if (CACHED_DEFAULTS.containsKey(worldDimensionEffects.getClass())) {
            return CACHED_DEFAULTS.get(worldDimensionEffects.getClass());
        }
        if (worldDimensionEffects instanceof DimensionSpecialEffects.OverworldEffects) {
            FogColors fogColors = new FogColors("#b9d2fd", "#000000");
            CACHED_DEFAULTS.put(worldDimensionEffects.getClass(), fogColors);
            return fogColors;
        }
        Minecraft client = Minecraft.getInstance();
        float sunHeight = Mth.clamp((float)(Mth.cos((float)(world.getTimeOfDay(TickUtil.getTickDelta()) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        Vec3 daySkyColor = worldDimensionEffects.getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)world.getBiomeManager().getNoiseBiomeAtPosition(client.player.getX(), client.player.getY(), client.player.getZ()).value()).getFogColor()), sunHeight);
        Vec3 nightSkyColor = daySkyColor.scale(0.2);
        FogColors fogColors = new FogColors(Color.from(daySkyColor).asHex(), Color.from(nightSkyColor).asHex());
        CACHED_DEFAULTS.put(worldDimensionEffects.getClass(), fogColors);
        return fogColors;
    }

    public FogColors(@NotNull String day, @NotNull String night) {
        assert (day.matches("^#[0-9a-fA-F]{6}$")) : "Invalid day color format: " + day;
        assert (night.matches("^#[0-9a-fA-F]{6}$")) : "Invalid night color format: " + night;
        this.day = day;
        this.night = night;
    }

    public Color getDayColor() {
        if (this.dayCached == null) {
            this.dayCached = Color.parse(this.day);
        }
        return this.dayCached;
    }

    public Color getNightColor() {
        if (this.nightCached == null) {
            this.nightCached = Color.parse(this.night);
        }
        return this.nightCached;
    }

    @NotNull
    private String getDay() {
        return this.day;
    }

    @NotNull
    private String getNight() {
        return this.night;
    }

    public static class Builder {
        @NotNull
        private String day = FogColors.getDefault(null).getDay();
        @NotNull
        private String night = FogColors.getDefault(null).getNight();

        @NotNull
        public Builder day(@NotNull String day) {
            this.day = day;
            return this;
        }

        @NotNull
        public Builder night(@NotNull String night) {
            this.night = night;
            return this;
        }

        @NotNull
        public FogColors build() {
            return new FogColors(this.day, this.night);
        }
    }
}

