/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client;

import dev.imb11.fog.api.CustomFogDefinition;
import dev.imb11.fog.api.FogColors;
import dev.imb11.fog.client.compat.polytone.PolytoneCompat;
import dev.imb11.fog.client.registry.FogRegistry;
import dev.imb11.fog.client.util.TickUtil;
import dev.imb11.fog.client.util.color.Color;
import dev.imb11.fog.client.util.math.DarknessCalculation;
import dev.imb11.fog.client.util.math.InterpolatedValue;
import dev.imb11.fog.client.util.math.MathUtil;
import dev.imb11.fog.client.util.player.PlayerUtil;
import dev.imb11.fog.client.util.world.ClientWorldUtil;
import dev.imb11.fog.config.FogConfig;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    public static FogManager INSTANCE = new FogManager();
    public final InterpolatedValue raininess;
    public final InterpolatedValue undergroundness;
    public final InterpolatedValue fogStart;
    public final InterpolatedValue fogEnd;
    public final InterpolatedValue darkness;
    public final InterpolatedValue fogColorRed;
    public final InterpolatedValue fogColorGreen;
    public final InterpolatedValue fogColorBlue;
    public final InterpolatedValue currentSkyLight;
    public final InterpolatedValue currentBlockLight;
    public final InterpolatedValue currentLight;
    public final InterpolatedValue currentStartMultiplier;
    public final InterpolatedValue currentEndMultiplier;
    public boolean hasSetup = false;

    public FogManager() {
        @NotNull FogConfig config = FogConfig.getInstance();
        this.raininess = new InterpolatedValue(0.0f, config.raininessTransitionSpeed);
        this.undergroundness = new InterpolatedValue(0.0f, config.undergroundnessTransitionSpeed);
        this.fogStart = new InterpolatedValue(config.initialFogStart, config.fogStartTransitionSpeed);
        this.fogEnd = new InterpolatedValue(config.initialFogEnd, config.fogEndTransitionSpeed);
        this.darkness = new InterpolatedValue(0.0f, config.darknessTransitionSpeed);
        this.fogColorRed = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.fogColorGreen = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.fogColorBlue = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.currentSkyLight = new InterpolatedValue(16.0f);
        this.currentBlockLight = new InterpolatedValue(16.0f);
        this.currentLight = new InterpolatedValue(16.0f);
        this.currentStartMultiplier = new InterpolatedValue(1.0f, config.startMultiplierTransitionSpeed);
        this.currentEndMultiplier = new InterpolatedValue(1.0f, config.endMultiplierTransitionSpeed);
        this.fogStart.resetTo(config.initialFogStart);
        this.fogEnd.resetTo(config.initialFogEnd);
    }

    @NotNull
    public static FogManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInDisabledBiome() {
        Minecraft client = Minecraft.getInstance();
        ClientLevel world = client.level;
        LocalPlayer player = client.player;
        if (world == null || player == null) {
            return false;
        }
        return FogConfig.getInstance().disabledBiomes.contains(world.getBiomeManager().getBiome(player.blockPosition()).getRegisteredName());
    }

    private static float getBlendFactor(@NotNull ClientLevel world) {
        long time = world.getDayTime() % 24000L;
        float blendFactor = time < 11000L ? 1.0f : (time < 13000L ? MathUtil.lerp(1.0f, 0.0f, (float)(time - 11000L) / 2000.0f) : (time < 22000L ? 0.0f : (time < 23000L ? MathUtil.lerp(0.0f, 1.0f, (float)(time - 22000L) / 1000.0f) : 1.0f)));
        return blendFactor;
    }

    public void onEndTick(@NotNull ClientLevel clientWorld) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer clientPlayer = client.player;
        if (clientPlayer == null) {
            return;
        }
        @Nullable BlockPos clientPlayerBlockPosition = clientPlayer.blockPosition();
        if (clientPlayerBlockPosition == null) {
            return;
        }
        boolean isClientPlayerAboveGround = PlayerUtil.isPlayerAboveGround(clientPlayer);
        if (isClientPlayerAboveGround) {
            this.undergroundness.interpolate(0.0f);
        } else {
            this.undergroundness.interpolate(1.0f);
        }
        if (isClientPlayerAboveGround && ((Biome)clientWorld.getBiome(clientPlayer.blockPosition()).value()).hasPrecipitation() && clientWorld.isRaining()) {
            this.raininess.interpolate(clientWorld.isThundering() ? 1.0f : 0.5f);
        } else {
            this.raininess.interpolate(0.0f);
        }
        float density = ClientWorldUtil.isFogDenseAtPosition(clientWorld, clientPlayerBlockPosition) ? 0.9f : 1.0f;
        float tickDelta = TickUtil.getTickDelta();
        DarknessCalculation darknessCalculation = DarknessCalculation.of(client, this.fogStart.getDefaultValue(), this.fogEnd.getDefaultValue() * density, tickDelta);
        Holder biomeKey = clientWorld.getBiome(clientPlayer.blockPosition());
        Optional clientPlayerBiomeKeyOptional = biomeKey.unwrapKey();
        if (clientPlayerBiomeKeyOptional.isEmpty()) {
            return;
        }
        CustomFogDefinition fogDefinition = FogRegistry.getFogDefinitionOrDefault(((ResourceKey)clientPlayerBiomeKeyOptional.get()).location(), clientWorld);
        @Nullable FogColors colors = fogDefinition.colors();
        if (colors == null || !FogConfig.getInstance().enableBiomeSpecificFogColors) {
            colors = FogColors.getDefault(clientWorld);
        }
        if (PolytoneCompat.shouldUsePolytone()) {
            colors = PolytoneCompat.getFogColorsFromPolytone((ResourceKey<Biome>)((ResourceKey)clientPlayerBiomeKeyOptional.get()), colors);
        }
        float blendFactor = FogManager.getBlendFactor(clientWorld);
        Color finalNightColor = this.getFinalNightColor(clientWorld, colors);
        float red = Mth.lerp((float)blendFactor, (float)((float)finalNightColor.red / 255.0f), (float)((float)colors.getDayColor().red / 255.0f));
        float green = Mth.lerp((float)blendFactor, (float)((float)finalNightColor.green / 255.0f), (float)((float)colors.getDayColor().green / 255.0f));
        float blue = Mth.lerp((float)blendFactor, (float)((float)finalNightColor.blue / 255.0f), (float)((float)colors.getDayColor().blue / 255.0f));
        if (!this.hasSetup) {
            this.fogColorRed.set(red);
            this.fogColorGreen.set(green);
            this.fogColorBlue.set(blue);
            this.hasSetup = true;
        } else {
            this.fogColorRed.interpolate(red);
            this.fogColorGreen.interpolate(green);
            this.fogColorBlue.interpolate(blue);
        }
        this.currentStartMultiplier.interpolate(fogDefinition.startMultiplier());
        this.currentEndMultiplier.interpolate(fogDefinition.endMultiplier());
        this.fogStart.interpolate(darknessCalculation.fogStart());
        this.fogEnd.interpolate(darknessCalculation.fogEnd());
        this.darkness.interpolate(darknessCalculation.darknessValue());
        this.currentSkyLight.interpolate(clientWorld.getBrightness(LightLayer.SKY, clientPlayerBlockPosition));
        this.currentBlockLight.interpolate(clientWorld.getBrightness(LightLayer.BLOCK, clientPlayerBlockPosition));
        this.currentLight.interpolate(clientWorld.getRawBrightness(clientPlayerBlockPosition, 0));
    }

    @NotNull
    private Color getFinalNightColor(@NotNull ClientLevel world, FogColors fogColors) {
        if (!FogConfig.getInstance().enableMoonFogColorInfluence) {
            return fogColors.getNightColor();
        }
        @NotNull Color newMoonColor = Color.from(FogConfig.getInstance().newMoonColor);
        float blendFactor = switch (world.getMoonPhase()) {
            case 0 -> 0.0f;
            case 1, 7 -> 0.25f;
            case 2, 6 -> 0.5f;
            case 3, 5 -> 0.75f;
            case 4 -> 1.0f;
            default -> 1.0f;
        };
        return fogColors.getNightColor().lerp(newMoonColor, blendFactor);
    }

    public float getUndergroundFactor(@NotNull Minecraft client, float tickDelta) {
        Entity clientCamera = client.getCameraEntity();
        ClientLevel clientWorld = client.level;
        if (clientCamera == null || clientWorld == null) {
            return 0.0f;
        }
        float clientCameraYPosition = (float)clientCamera.getY();
        float seaLevel = clientWorld.getSeaLevel();
        float yFactor = Mth.clamp((float)MathUtil.mapRange(seaLevel - 32.0f, seaLevel + 32.0f, 1.0f, 0.0f, clientCameraYPosition), (float)0.0f, (float)1.0f);
        float undergroundnessValue = this.undergroundness.get(tickDelta);
        float skyLight = this.currentSkyLight.get(tickDelta);
        return Mth.lerp((float)yFactor, (float)(1.0f - undergroundnessValue), (float)(skyLight / 16.0f));
    }

    @NotNull
    public FogSettings getFogSettings(float tickDelta, float viewDistance) {
        FogConfig fogConfig = FogConfig.getInstance();
        float fogStart = this.fogStart.get(tickDelta) * this.currentStartMultiplier.get(tickDelta);
        float fogEnd = this.fogEnd.get(tickDelta) * this.currentEndMultiplier.get(tickDelta);
        float fogRed = this.fogColorRed.get(tickDelta);
        float fogGreen = this.fogColorGreen.get(tickDelta);
        float fogBlue = this.fogColorBlue.get(tickDelta);
        float[] sunriseSunsetAdjustedFogColors = this.blendFogColorWithSunriseSunsetColors(Minecraft.getInstance(), fogRed, fogGreen, fogBlue, tickDelta);
        fogRed = sunriseSunsetAdjustedFogColors[0];
        fogGreen = sunriseSunsetAdjustedFogColors[1];
        fogBlue = sunriseSunsetAdjustedFogColors[2];
        float darknessFogColorMultiplier = 1.0f - this.darkness.get(tickDelta);
        fogRed *= darknessFogColorMultiplier;
        fogGreen *= darknessFogColorMultiplier;
        fogBlue *= darknessFogColorMultiplier;
        float undergroundness = this.undergroundness.get(tickDelta);
        float undergroundFogMultiplier = 1.0f - undergroundness * fogConfig.undergroundFogMultiplier;
        fogStart *= undergroundFogMultiplier;
        fogEnd *= undergroundFogMultiplier;
        float rainFogMultiplier = 1.0f - Math.clamp(this.raininess.get(tickDelta) - undergroundness, 0.0f, 1.0f) * fogConfig.rainFogMultiplier;
        return new FogSettings((fogStart *= rainFogMultiplier) * viewDistance, (fogEnd *= Math.clamp(rainFogMultiplier, 0.5f, 1.0f)) * viewDistance, fogRed *= rainFogMultiplier, fogGreen *= rainFogMultiplier, fogBlue *= rainFogMultiplier);
    }

    private float[] blendFogColorWithSunriseSunsetColors(@NotNull Minecraft client, float red, float green, float blue, float tickDelta) {
        Vec3 sunColor;
        boolean isSunset;
        if (!FogConfig.getInstance().enableSunFogColorInfluence || client.level == null) {
            return new float[]{red, green, blue};
        }
        float skyAngle = client.level.getTimeOfDay(tickDelta);
        if (client.level.effects() instanceof DimensionSpecialEffects.OverworldEffects) {
            float cosAngle = Mth.cos((float)(skyAngle * ((float)Math.PI * 2)));
            isSunset = cosAngle >= -0.4f && cosAngle <= 0.4f;
            float g = Math.max(cosAngle, 0.0f) / 0.4f * 0.5f + 0.5f;
            float h = 1.0f - (1.0f - Mth.sin((float)(g * (float)Math.PI))) * 0.99f;
            h *= h;
            int color = (Mth.floor((float)(h * 255.0f)) & 0xFF) << 24 | (Mth.floor((float)((g * 0.3f + 0.7f) * 255.0f)) & 0xFF) << 16 | (Mth.floor((float)((g * g * 0.7f + 0.2f) * 255.0f)) & 0xFF) << 8 | Mth.floor((float)51.0f) & 0xFF;
            sunColor = Vec3.fromRGB24((int)color);
        } else {
            isSunset = false;
            sunColor = Vec3.ZERO;
        }
        if (isSunset) {
            float cosAngle = Mth.cos((float)(skyAngle * ((float)Math.PI * 2)));
            float blendIntensity = 1.0f - Math.abs(cosAngle) / 0.4f;
            if ((blendIntensity = Mth.clamp((float)(blendIntensity * blendIntensity * (3.0f - 2.0f * blendIntensity)), (float)0.0f, (float)1.0f)) > 0.0f) {
                float sunR = (float)sunColor.x;
                float sunG = (float)sunColor.y;
                float sunB = (float)sunColor.z;
                red = Mth.lerp((float)(blendIntensity * 0.7f), (float)red, (float)sunR);
                green = Mth.lerp((float)(blendIntensity * 0.7f), (float)green, (float)sunG);
                blue = Mth.lerp((float)(blendIntensity * 0.7f), (float)blue, (float)sunB);
            }
        }
        return new float[]{red, green, blue};
    }

    public record FogSettings(double fogStart, double fogEnd, float fogRed, float fogGreen, float fogBlue) {
    }
}

