/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.imb11.fog.api.CustomFogDefinition;
import dev.imb11.fog.client.FogClient;
import dev.imb11.fog.client.registry.FogRegistry;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogResourceReloader
extends SimplePreparableReloadListener<Void> {
    @NotNull
    public static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"fog", (String)"resource_reloader");
    @NotNull
    private static final String TAG_FOLDER_NAME = "tag";
    @NotNull
    public static final String FOG_DEFINITIONS_FOLDER_NAME = "fog_definitions";
    @NotNull
    public static final String STRUCTURE_FOLDER_NAME = "structure";
    @NotNull
    public static final String STRUCTURE_TAGS_FOLDER_NAME = String.format("%s/%s", "tag", "structure");
    @NotNull
    public static final String BIOME_FOLDER_NAME = "biome";
    @NotNull
    public static final String BIOME_TAGS_FOLDER_NAME = String.format("%s/%s", "tag", "biome");
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final String JSON_FILE_SUFFIX = ".json";

    @Nullable
    protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        FogRegistry.resetCaches();
        this.loadTaggedFogs(resourceManager, STRUCTURE_TAGS_FOLDER_NAME, FogRegistry.getStructureTagFogRegistry(), Registries.STRUCTURE);
        this.loadTaggedFogs(resourceManager, BIOME_TAGS_FOLDER_NAME, FogRegistry.getBiomeTagFogRegistry(), Registries.BIOME);
        this.loadFogs(resourceManager, STRUCTURE_FOLDER_NAME, FogRegistry.getStructureFogRegistry());
        this.loadFogs(resourceManager, BIOME_FOLDER_NAME, FogRegistry.getBiomeFogRegistry());
        return null;
    }

    protected void apply(@Nullable Void prepared, ResourceManager resourceManager, ProfilerFiller profiler) {
    }

    private <K> void loadFogs(@NotNull ResourceManager resourceManager, @NotNull String folderName, @NotNull Map<K, CustomFogDefinition> fogRegistry, @NotNull Function<String, K> keyGenerator) {
        fogRegistry.clear();
        Map jsonFogs = resourceManager.listResources(String.format("%s/%s", FOG_DEFINITIONS_FOLDER_NAME, folderName), identifier -> identifier.toString().endsWith(JSON_FILE_SUFFIX));
        for (Map.Entry jsonFog : jsonFogs.entrySet()) {
            ResourceLocation jsonFogPath = (ResourceLocation)jsonFog.getKey();
            String[] jsonFogPathSplit = jsonFogPath.getPath().replace(JSON_FILE_SUFFIX, "").split("/");
            ResourceLocation fogIdentifier = ResourceLocation.fromNamespaceAndPath((String)jsonFogPath.getNamespace(), (String)jsonFogPathSplit[jsonFogPathSplit.length - 1]);
            K fogKey = keyGenerator.apply(fogIdentifier.toString());
            if (fogRegistry.containsKey(fogKey)) continue;
            try {
                fogRegistry.put(fogKey, (CustomFogDefinition)CustomFogDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(new String(((Resource)jsonFog.getValue()).open().readAllBytes()), JsonElement.class))).result().orElseThrow());
            }
            catch (IOException e) {
                FogClient.LOGGER.error("Exception thrown while deserializing a fog definition (identifier: {}): {}", (Object)fogIdentifier, (Object)e);
            }
        }
    }

    private <T> void loadTaggedFogs(@NotNull ResourceManager resourceManager, @NotNull String folderName, @NotNull Map<TagKey<T>, CustomFogDefinition> fogRegistry, ResourceKey<? extends Registry<T>> registryKey) {
        this.loadFogs(resourceManager, folderName, fogRegistry, identifier -> TagKey.create((ResourceKey)registryKey, (ResourceLocation)ResourceLocation.tryParse((String)identifier)));
    }

    private void loadFogs(@NotNull ResourceManager resourceManager, @NotNull String folderName, @NotNull Map<ResourceLocation, CustomFogDefinition> fogRegistry) {
        this.loadFogs(resourceManager, folderName, fogRegistry, ResourceLocation::tryParse);
    }
}

